/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor;

import com.android.tools.idea.gradle.structure.configurables.editor.ModuleConfigurationEditor;
import com.android.tools.idea.gradle.structure.configurables.editor.dependencies.DependenciesEditor;
import com.android.tools.idea.gradle.structure.configurables.model.ModuleMergedModel;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEditor
implements Place.Navigator,
Disposable {
    @NonNls
    protected static final String SELECTED_EDITOR_NAME = "selectedEditor";
    @NotNull
    private final ModuleMergedModel myModel;
    @NotNull
    private final List<ModuleConfigurationEditor> myEditors;
    @Nullable
    private History myHistory;
    private JPanel mySettingsPanel;

    protected ModuleEditor(@NotNull ModuleMergedModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/editor/ModuleEditor", "<init>"));
        }
        this.myEditors = Lists.newArrayList();
        this.myModel = model;
    }

    public void init(@Nullable History history) {
        this.setHistory(history);
        for (ModuleConfigurationEditor editor : this.myEditors) {
            editor.setHistory(this.myHistory);
        }
        this.restoreSelectedEditor();
    }

    protected abstract void restoreSelectedEditor();

    @NotNull
    public JPanel getPanel() {
        if (this.mySettingsPanel == null) {
            this.createEditors();
            this.mySettingsPanel = new JPanel(new BorderLayout());
            this.mySettingsPanel.add((Component)this.createCenterPanel(), "Center");
        }
        JPanel jPanel = this.mySettingsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/ModuleEditor", "getPanel"));
        }
        return jPanel;
    }

    private void createEditors() {
        this.myEditors.add(new DependenciesEditor(this.myModel));
    }

    @NotNull
    protected abstract JComponent createCenterPanel();

    @Nullable
    public String getHelpTopic() {
        if (this.myEditors.isEmpty()) {
            return null;
        }
        ModuleConfigurationEditor selectedEditor = this.getSelectedEditor();
        return selectedEditor != null ? selectedEditor.getHelpTopic() : null;
    }

    @Nullable
    public abstract ModuleConfigurationEditor getSelectedEditor();

    public abstract void selectEditor(@Nullable String var1);

    @Nullable
    public abstract ModuleConfigurationEditor getEditor(@NotNull String var1);

    public void apply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            editor.saveData();
            editor.apply();
        }
    }

    public void canApply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (!(editor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)editor).canApply();
        }
    }

    public void setHistory(@Nullable History history) {
        this.myHistory = history;
    }

    public void dispose() {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            editor.disposeUIResources();
        }
        this.myEditors.clear();
        this.disposeCenterPanel();
    }

    protected abstract void disposeCenterPanel();

    @Nullable
    public History getHistory() {
        return this.myHistory;
    }

    @NotNull
    public List<ModuleConfigurationEditor> getEditors() {
        List<ModuleConfigurationEditor> list = this.myEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/ModuleEditor", "getEditors"));
        }
        return list;
    }
}

