/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.service.notification.hyperlink.CustomNotificationListener;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.google.common.base.Objects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleNotification {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Android/Gradle Notification Group");
    @Nullable
    private Notification myNotification;
    @NotNull
    private final Project myProject;

    @NotNull
    public static AndroidGradleNotification getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "getInstance"));
        }
        AndroidGradleNotification androidGradleNotification = (AndroidGradleNotification)ServiceManager.getService((Project)project, AndroidGradleNotification.class);
        if (androidGradleNotification == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "getInstance"));
        }
        return androidGradleNotification;
    }

    public AndroidGradleNotification(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "<init>"));
        }
        this.myProject = project;
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        this.showBalloon(title, text, type, (NotificationListener)null);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        this.showBalloon(title, text, type, NOTIFICATION_GROUP, hyperlinks);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, NotificationHyperlink ... hyperlinks) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        CustomNotificationListener notificationListener = new CustomNotificationListener(this.myProject, hyperlinks);
        String newText = AndroidGradleNotification.addHyperlinksToText(text, hyperlinks);
        this.showBalloon(title, newText, type, group, (NotificationListener)notificationListener);
    }

    @NotNull
    private static String addHyperlinksToText(@NotNull String text, NotificationHyperlink ... hyperlinks) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "addHyperlinksToText"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "addHyperlinksToText"));
        }
        if (hyperlinks.length == 0) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "addHyperlinksToText"));
            }
            return string;
        }
        StringBuilder b = new StringBuilder();
        b.append(text);
        for (NotificationHyperlink hyperlink : hyperlinks) {
            b.append("<br>\n").append(hyperlink.toHtml());
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "addHyperlinksToText"));
        }
        return string;
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        this.showBalloon(title, text, type, NOTIFICATION_GROUP, listener);
    }

    public void showBalloon(@NotNull String title, @NotNull String text, @NotNull NotificationType type, @NotNull NotificationGroup group, @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/gradle/project/AndroidGradleNotification", "showBalloon"));
        }
        final Notification notification = group.createNotification(title, text, type, listener);
        Runnable notificationTask = new Runnable(){

            @Override
            public void run() {
                if (!AndroidGradleNotification.this.myProject.isDisposed() && AndroidGradleNotification.this.myProject.isOpen()) {
                    boolean similar;
                    Notification old = AndroidGradleNotification.this.myNotification;
                    if (old != null && (similar = Objects.equal((Object)notification.getContent(), (Object)old.getContent()))) {
                        old.expire();
                    }
                    AndroidGradleNotification.this.myNotification = notification;
                    notification.notify(AndroidGradleNotification.this.myProject);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            notificationTask.run();
        } else {
            application.invokeLater(notificationTask);
        }
    }

    @Nullable
    public Notification getNotification() {
        return this.myNotification;
    }
}

