/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.IDevice;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunUtils {
    private static final Key<Boolean> CLEAN_BUILD = Key.create((String)"android.instant.run.clean");
    private static final Key<Boolean> FULL_BUILD = Key.create((String)"android.instant.run.full.build");
    private static final Key<Boolean> APP_RUNNING = Key.create((String)"android.instant.run.app.running");
    private static final Key<IDevice> RESTART_ON_DEVICE = Key.create((String)"android.instant.run.restart.device");
    private static final Key<Boolean> IR_ENABLED = Key.create((String)"android.instant.run.enabled.for.run.config");
    private static final Key<Boolean> RERUN = Key.create((String)"android.instant.run.rerun");
    private static final Key<Boolean> CLEAN_RERUN = Key.create((String)"android.instant.run.clean.rerun");

    public static void setInstantRunEnabled(@NotNull ExecutionEnvironment env, boolean en) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setInstantRunEnabled"));
        }
        env.putCopyableUserData(IR_ENABLED, (Object)en);
    }

    public static boolean isInstantRunEnabled(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "isInstantRunEnabled"));
        }
        return Boolean.TRUE.equals(env.getCopyableUserData(IR_ENABLED));
    }

    public static boolean needsFullBuild(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "needsFullBuild"));
        }
        return Boolean.TRUE.equals(env.getCopyableUserData(FULL_BUILD));
    }

    public static void setNeedsFullBuild(@NotNull ExecutionEnvironment env, boolean en) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setNeedsFullBuild"));
        }
        env.putCopyableUserData(FULL_BUILD, (Object)en);
    }

    public static boolean needsCleanBuild(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "needsCleanBuild"));
        }
        return Boolean.TRUE.equals(env.getCopyableUserData(CLEAN_BUILD));
    }

    public static void setNeedsCleanBuild(@NotNull ExecutionEnvironment env, boolean en) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setNeedsCleanBuild"));
        }
        env.putCopyableUserData(CLEAN_BUILD, (Object)en);
    }

    public static boolean isAppRunning(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "isAppRunning"));
        }
        return Boolean.TRUE.equals(env.getCopyableUserData(APP_RUNNING));
    }

    public static void setAppRunning(@NotNull ExecutionEnvironment env, boolean en) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setAppRunning"));
        }
        env.putCopyableUserData(APP_RUNNING, (Object)en);
    }

    public static void setRestartSession(@NotNull ExecutionEnvironment env, @NotNull IDevice device) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setRestartSession"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunUtils", "setRestartSession"));
        }
        InstantRunUtils.setNeedsFullBuild(env, true);
        InstantRunUtils.setAppRunning(env, false);
        env.putCopyableUserData(RESTART_ON_DEVICE, (Object)device);
    }

    @Nullable
    public static IDevice getRestartDevice(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "getRestartDevice"));
        }
        return (IDevice)env.getCopyableUserData(RESTART_ON_DEVICE);
    }

    public static void setReRun(@NotNull ExecutionEnvironment env, boolean en) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setReRun"));
        }
        env.putCopyableUserData(RERUN, (Object)en);
    }

    public static boolean isReRun(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "isReRun"));
        }
        return Boolean.TRUE.equals(env.getCopyableUserData(RERUN));
    }

    public static void setCleanReRun(@NotNull ExecutionEnvironment env, boolean en) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "setCleanReRun"));
        }
        env.putCopyableUserData(CLEAN_RERUN, (Object)en);
    }

    public static boolean isCleanReRun(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/fd/InstantRunUtils", "isCleanReRun"));
        }
        return Boolean.TRUE.equals(env.getCopyableUserData(CLEAN_RERUN));
    }
}

