/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class AttributesGrouper {
    private AttributesGrouper() {
    }

    @NotNull
    private static List<TableLabel> generateLabelsForType(@NotNull List<EditedStyleItem> source, @NotNull List<EditedStyleItem> sink) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabelsForType"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabelsForType"));
        }
        ArrayListMultimap classes = ArrayListMultimap.create();
        for (EditedStyleItem item : source) {
            String name = item.getName();
            classes.put((Object)Group.getGroupFromName(name), (Object)item);
        }
        ArrayList<TableLabel> labels = new ArrayList<TableLabel>();
        int offset = 0;
        for (Group group : Group.values()) {
            boolean addHeader;
            Collection elements = classes.get((Object)group);
            boolean bl = addHeader = !elements.isEmpty();
            if (addHeader && group == Group.OTHER) {
                boolean bl2 = addHeader = offset != 0;
            }
            if (addHeader) {
                labels.add(new TableLabel(group.name, offset));
            }
            sink.addAll(elements);
            offset += elements.size();
        }
        ArrayList<TableLabel> arrayList = labels;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabelsForType"));
        }
        return arrayList;
    }

    @NotNull
    private static List<TableLabel> generateLabelsForGroup(List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        ListMultimap classes = Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<EditedStyleItem>>(){

            public List<EditedStyleItem> get() {
                return new ArrayList<EditedStyleItem>();
            }
        });
        for (EditedStyleItem item : source) {
            String group = item.getAttrGroup();
            classes.put((Object)group, (Object)item);
        }
        ArrayList<TableLabel> labels = new ArrayList<TableLabel>();
        int offset = 0;
        sink.clear();
        for (String group : classes.keySet()) {
            int size = classes.get((Object)group).size();
            sink.addAll(classes.get((Object)group));
            if (size != 0) {
                labels.add(new TableLabel(group, offset));
            }
            offset += size;
        }
        ArrayList<TableLabel> arrayList = labels;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabelsForGroup"));
        }
        return arrayList;
    }

    @NotNull
    public static List<TableLabel> generateLabels(@NotNull GroupBy group, List<EditedStyleItem> source, List<EditedStyleItem> sink) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabels"));
        }
        switch (group) {
            case TYPE: {
                List<TableLabel> list = AttributesGrouper.generateLabelsForType(source, sink);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabels"));
                }
                return list;
            }
            case GROUP: {
                List<TableLabel> list = AttributesGrouper.generateLabelsForGroup(source, sink);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper", "generateLabels"));
                }
                return list;
            }
        }
        throw new IllegalArgumentException();
    }

    private static enum Group {
        STYLES("Styles", (List<String>)ImmutableList.of((Object)"style", (Object)"theme")),
        COLORS("Colors", (List<String>)ImmutableList.of((Object)"color")),
        DRAWABLES("Drawables", (List<String>)ImmutableList.of((Object)"drawable")),
        METRICS("Metrics", (List<String>)ImmutableList.of((Object)"size", (Object)"width", (Object)"height")),
        OTHER("Everything Else", Collections.<String>emptyList());

        public final String name;
        public final List<String> markers;

        private Group(String name, List<String> markers) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper$Group", "<init>"));
            }
            if (markers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/android/tools/idea/editors/theme/attributes/AttributesGrouper$Group", "<init>"));
            }
            this.name = name;
            this.markers = markers;
        }

        private static Group getGroupFromName(String name) {
            for (Group group : Group.values()) {
                for (String marker : group.markers) {
                    if (!StringUtil.containsIgnoreCase((String)name, (String)marker)) continue;
                    return group;
                }
            }
            return OTHER;
        }
    }

    public static enum GroupBy {
        GROUP("By Group"),
        TYPE("By Type");

        private final String myText;

        private GroupBy(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }
}

