/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;

final class XmlTagUtils {
    @NotNull
    private static final Escaper ESCAPER = Escapers.builder().addEscape('\'', "\\'").build();

    private XmlTagUtils() {
    }

    static void escape(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/editors/strings/XmlTagUtils", "escape"));
        }
        for (XmlTagChild child : tag.getValue().getChildren()) {
            if (child instanceof XmlText) {
                XmlText text = (XmlText)child;
                if (text.getText().contains("<![CDATA[")) continue;
                text.setValue(ESCAPER.escape(text.getValue()));
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTagUtils.escape((XmlTag)child);
        }
    }

    @NotNull
    static String unescape(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/editors/strings/XmlTagUtils", "unescape"));
        }
        StringBuilder builder = new StringBuilder();
        XmlTagUtils.unescape(builder, tag);
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/strings/XmlTagUtils", "unescape"));
        }
        return string;
    }

    private static void unescape(@NotNull StringBuilder builder, @NotNull XmlTag tag) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/editors/strings/XmlTagUtils", "unescape"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/editors/strings/XmlTagUtils", "unescape"));
        }
        for (XmlTagChild child : tag.getValue().getChildren()) {
            if (child instanceof XmlText) {
                String text = ((XmlText)child).getText();
                if (!text.contains("<![CDATA[")) {
                    text = text.replaceAll("\\\\'", "'");
                }
                builder.append(text);
                continue;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTag childTag = (XmlTag)child;
            String name = childTag.getName();
            builder.append('<');
            builder.append(name);
            XmlTagUtils.appendAttributes(builder, childTag);
            builder.append('>');
            XmlTagUtils.unescape(builder, childTag);
            builder.append("</");
            builder.append(name);
            builder.append('>');
        }
    }

    private static void appendAttributes(@NotNull StringBuilder builder, @NotNull XmlTag tag) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/editors/strings/XmlTagUtils", "appendAttributes"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/editors/strings/XmlTagUtils", "appendAttributes"));
        }
        for (XmlAttribute attribute : tag.getAttributes()) {
            builder.append(' ');
            builder.append(attribute.getName());
            builder.append("=\"");
            builder.append(attribute.getValue());
            builder.append('\"');
        }
    }
}

