/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service;

import com.android.tools.idea.editors.gfxtrace.service.CallFollow;
import com.android.tools.idea.editors.gfxtrace.service.CallGet;
import com.android.tools.idea.editors.gfxtrace.service.CallGetAvailableStringTables;
import com.android.tools.idea.editors.gfxtrace.service.CallGetCaptures;
import com.android.tools.idea.editors.gfxtrace.service.CallGetDevices;
import com.android.tools.idea.editors.gfxtrace.service.CallGetFeatures;
import com.android.tools.idea.editors.gfxtrace.service.CallGetFramebufferColor;
import com.android.tools.idea.editors.gfxtrace.service.CallGetFramebufferDepth;
import com.android.tools.idea.editors.gfxtrace.service.CallGetSchema;
import com.android.tools.idea.editors.gfxtrace.service.CallGetStringTable;
import com.android.tools.idea.editors.gfxtrace.service.CallGetTimingInfo;
import com.android.tools.idea.editors.gfxtrace.service.CallImportCapture;
import com.android.tools.idea.editors.gfxtrace.service.CallLoadCapture;
import com.android.tools.idea.editors.gfxtrace.service.CallSet;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ResultFollow;
import com.android.tools.idea.editors.gfxtrace.service.ResultGet;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetAvailableStringTables;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetCaptures;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetDevices;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetFeatures;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetFramebufferColor;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetFramebufferDepth;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetSchema;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetStringTable;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetTimingInfo;
import com.android.tools.idea.editors.gfxtrace.service.ResultImportCapture;
import com.android.tools.idea.editors.gfxtrace.service.ResultLoadCapture;
import com.android.tools.idea.editors.gfxtrace.service.ResultSet;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.TimingFlags;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.TimingInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.stringtable.Info;
import com.android.tools.idea.editors.gfxtrace.service.stringtable.StringTable;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.rpccore.Broadcaster;
import com.android.tools.rpclib.schema.Message;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public final class ServiceClientRPC
extends ServiceClient {
    private final Broadcaster myBroadcaster;
    private final ListeningExecutorService myExecutorService;

    public ServiceClientRPC(ListeningExecutorService executorService, InputStream in, OutputStream out, int mtu, int version) {
        this.myExecutorService = executorService;
        this.myBroadcaster = new Broadcaster(in, out, mtu, (ExecutorService)this.myExecutorService, version);
    }

    @Override
    public ListenableFuture<Path> follow(Path p) {
        return this.myExecutorService.submit((Callable)new FollowCallable(p));
    }

    @Override
    public ListenableFuture<Object> get(Path p) {
        return this.myExecutorService.submit((Callable)new GetCallable(p));
    }

    @Override
    public ListenableFuture<Info[]> getAvailableStringTables() {
        return this.myExecutorService.submit((Callable)new GetAvailableStringTablesCallable());
    }

    @Override
    public ListenableFuture<CapturePath[]> getCaptures() {
        return this.myExecutorService.submit((Callable)new GetCapturesCallable());
    }

    @Override
    public ListenableFuture<DevicePath[]> getDevices() {
        return this.myExecutorService.submit((Callable)new GetDevicesCallable());
    }

    @Override
    public ListenableFuture<String[]> getFeatures() {
        return this.myExecutorService.submit((Callable)new GetFeaturesCallable());
    }

    @Override
    public ListenableFuture<ImageInfoPath> getFramebufferColor(DevicePath device, AtomPath after, RenderSettings settings) {
        return this.myExecutorService.submit((Callable)new GetFramebufferColorCallable(device, after, settings));
    }

    @Override
    public ListenableFuture<ImageInfoPath> getFramebufferDepth(DevicePath device, AtomPath after) {
        return this.myExecutorService.submit((Callable)new GetFramebufferDepthCallable(device, after));
    }

    @Override
    public ListenableFuture<Message> getSchema() {
        return this.myExecutorService.submit((Callable)new GetSchemaCallable());
    }

    @Override
    public ListenableFuture<StringTable> getStringTable(Info info) {
        return this.myExecutorService.submit((Callable)new GetStringTableCallable(info));
    }

    @Override
    public ListenableFuture<TimingInfoPath> getTimingInfo(DevicePath device, CapturePath capture, TimingFlags flags) {
        return this.myExecutorService.submit((Callable)new GetTimingInfoCallable(device, capture, flags));
    }

    @Override
    public ListenableFuture<CapturePath> importCapture(String name, byte[] Data2) {
        return this.myExecutorService.submit((Callable)new ImportCaptureCallable(name, Data2));
    }

    @Override
    public ListenableFuture<CapturePath> loadCapture(String path) {
        return this.myExecutorService.submit((Callable)new LoadCaptureCallable(path));
    }

    @Override
    public ListenableFuture<Path> set(Path p, Object v) {
        return this.myExecutorService.submit((Callable)new SetCallable(p, v));
    }

    private static class StackException
    extends Exception {
        private StackException() {
        }

        @Override
        public String toString() {
            return String.valueOf(this.getCause());
        }
    }

    private class SetCallable
    implements Callable<Path> {
        private final CallSet myCall;
        private final Exception myStack = new StackException();

        private SetCallable(Path p, Object v) {
            this.myCall = new CallSet();
            this.myCall.setP(p);
            this.myCall.setV(v);
        }

        @Override
        public Path call() throws Exception {
            try {
                ResultSet result = (ResultSet)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class LoadCaptureCallable
    implements Callable<CapturePath> {
        private final CallLoadCapture myCall;
        private final Exception myStack = new StackException();

        private LoadCaptureCallable(String path) {
            this.myCall = new CallLoadCapture();
            this.myCall.setPath(path);
        }

        @Override
        public CapturePath call() throws Exception {
            try {
                ResultLoadCapture result = (ResultLoadCapture)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class ImportCaptureCallable
    implements Callable<CapturePath> {
        private final CallImportCapture myCall;
        private final Exception myStack = new StackException();

        private ImportCaptureCallable(String name, byte[] Data2) {
            this.myCall = new CallImportCapture();
            this.myCall.setName(name);
            this.myCall.setData(Data2);
        }

        @Override
        public CapturePath call() throws Exception {
            try {
                ResultImportCapture result = (ResultImportCapture)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetTimingInfoCallable
    implements Callable<TimingInfoPath> {
        private final CallGetTimingInfo myCall;
        private final Exception myStack = new StackException();

        private GetTimingInfoCallable(DevicePath device, CapturePath capture, TimingFlags flags) {
            this.myCall = new CallGetTimingInfo();
            this.myCall.setDevice(device);
            this.myCall.setCapture(capture);
            this.myCall.setFlags(flags);
        }

        @Override
        public TimingInfoPath call() throws Exception {
            try {
                ResultGetTimingInfo result = (ResultGetTimingInfo)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetStringTableCallable
    implements Callable<StringTable> {
        private final CallGetStringTable myCall;
        private final Exception myStack = new StackException();

        private GetStringTableCallable(Info info) {
            this.myCall = new CallGetStringTable();
            this.myCall.setInfo(info);
        }

        @Override
        public StringTable call() throws Exception {
            try {
                ResultGetStringTable result = (ResultGetStringTable)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetSchemaCallable
    implements Callable<Message> {
        private final CallGetSchema myCall;
        private final Exception myStack = new StackException();

        private GetSchemaCallable() {
            this.myCall = new CallGetSchema();
        }

        @Override
        public Message call() throws Exception {
            try {
                ResultGetSchema result = (ResultGetSchema)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetFramebufferDepthCallable
    implements Callable<ImageInfoPath> {
        private final CallGetFramebufferDepth myCall;
        private final Exception myStack = new StackException();

        private GetFramebufferDepthCallable(DevicePath device, AtomPath after) {
            this.myCall = new CallGetFramebufferDepth();
            this.myCall.setDevice(device);
            this.myCall.setAfter(after);
        }

        @Override
        public ImageInfoPath call() throws Exception {
            try {
                ResultGetFramebufferDepth result = (ResultGetFramebufferDepth)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetFramebufferColorCallable
    implements Callable<ImageInfoPath> {
        private final CallGetFramebufferColor myCall;
        private final Exception myStack = new StackException();

        private GetFramebufferColorCallable(DevicePath device, AtomPath after, RenderSettings settings) {
            this.myCall = new CallGetFramebufferColor();
            this.myCall.setDevice(device);
            this.myCall.setAfter(after);
            this.myCall.setSettings(settings);
        }

        @Override
        public ImageInfoPath call() throws Exception {
            try {
                ResultGetFramebufferColor result = (ResultGetFramebufferColor)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetFeaturesCallable
    implements Callable<String[]> {
        private final CallGetFeatures myCall;
        private final Exception myStack = new StackException();

        private GetFeaturesCallable() {
            this.myCall = new CallGetFeatures();
        }

        @Override
        public String[] call() throws Exception {
            try {
                ResultGetFeatures result = (ResultGetFeatures)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetDevicesCallable
    implements Callable<DevicePath[]> {
        private final CallGetDevices myCall;
        private final Exception myStack = new StackException();

        private GetDevicesCallable() {
            this.myCall = new CallGetDevices();
        }

        @Override
        public DevicePath[] call() throws Exception {
            try {
                ResultGetDevices result = (ResultGetDevices)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetCapturesCallable
    implements Callable<CapturePath[]> {
        private final CallGetCaptures myCall;
        private final Exception myStack = new StackException();

        private GetCapturesCallable() {
            this.myCall = new CallGetCaptures();
        }

        @Override
        public CapturePath[] call() throws Exception {
            try {
                ResultGetCaptures result = (ResultGetCaptures)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetAvailableStringTablesCallable
    implements Callable<Info[]> {
        private final CallGetAvailableStringTables myCall;
        private final Exception myStack = new StackException();

        private GetAvailableStringTablesCallable() {
            this.myCall = new CallGetAvailableStringTables();
        }

        @Override
        public Info[] call() throws Exception {
            try {
                ResultGetAvailableStringTables result = (ResultGetAvailableStringTables)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class GetCallable
    implements Callable<Object> {
        private final CallGet myCall;
        private final Exception myStack = new StackException();

        private GetCallable(Path p) {
            this.myCall = new CallGet();
            this.myCall.setP(p);
        }

        @Override
        public Object call() throws Exception {
            try {
                ResultGet result = (ResultGet)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }

    private class FollowCallable
    implements Callable<Path> {
        private final CallFollow myCall;
        private final Exception myStack = new StackException();

        private FollowCallable(Path p) {
            this.myCall = new CallFollow();
            this.myCall.setP(p);
        }

        @Override
        public Path call() throws Exception {
            try {
                ResultFollow result = (ResultFollow)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
                return result.getValue();
            }
            catch (Exception e) {
                e.initCause(this.myStack);
                throw e;
            }
        }
    }
}

