/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.editors.gfxtrace.DeviceInfo;
import com.android.tools.idea.editors.gfxtrace.GfxTraceCaptureType;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.ProfilerState;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTracer {
    private static final long UPDATE_FREQUENCY_MS = 500L;
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTracer.class);
    @NotNull
    private static final String PRELOAD_LIB = "/data/local/tmp/libgapii.so";
    @NotNull
    private static final int GAPII_PORT = 9286;
    @NotNull
    private static final String GAPII_ABSTRACT_PORT = "gapii";
    private static final int GAPII_PROTOCOL_VERSION = 3;
    private static final int GAPII_FLAG_DISABLE_PRECOMPILED_SHADERS = 1;
    @NotNull
    private static final Pattern ENFORCING_PATTERN = Pattern.compile("^Enforcing$", 10);
    @NotNull
    private static final Pattern PERMISSIVE_PATTERN = Pattern.compile("^Permissive$|^Disabled$", 10);
    @NotNull
    private final IDevice myDevice;
    @NotNull
    final CaptureService myCaptureService;
    @NotNull
    final CaptureHandle myCapture;
    @NotNull
    final Listener myListener;
    private volatile boolean myStopped;

    public static GfxTracer launch(@NotNull Project project, @NotNull IDevice device, final @NotNull DeviceInfo.Package pkg, final @NotNull DeviceInfo.Activity act, final @NotNull Options options, @NotNull Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launch"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launch"));
        }
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launch"));
        }
        if (act == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "act", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launch"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launch"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launch"));
        }
        final GfxTracer tracer = new GfxTracer(project, device, options, listener);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                tracer.launchAndCapture(pkg, act, options);
            }
        });
        return tracer;
    }

    public static GfxTracer listen(@NotNull Project project, @NotNull IDevice device, final @NotNull Options options, @NotNull Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "listen"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "listen"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "listen"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "listen"));
        }
        final GfxTracer tracer = new GfxTracer(project, device, options, listener);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                tracer.capture(options);
            }
        });
        return tracer;
    }

    private GfxTracer(@NotNull Project project, @NotNull IDevice device, @NotNull Options options, @NotNull Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "<init>"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "<init>"));
        }
        this.myStopped = false;
        this.myCaptureService = CaptureService.getInstance(project);
        this.myDevice = device;
        this.myListener = listener;
        try {
            this.myCapture = this.myCaptureService.startCaptureFile(GfxTraceCaptureType.class, options.myTraceName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchAndCapture(@NotNull DeviceInfo.Package pkg, @NotNull DeviceInfo.Activity act, @NotNull Options options) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launchAndCapture"));
        }
        if (act == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "act", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launchAndCapture"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "launchAndCapture"));
        }
        try {
            boolean wasEnforcing;
            this.myListener.onAction("Launching application...");
            String abi = pkg.myABI;
            if (abi == null) {
                abi = (String)this.myDevice.getAbis().get(0);
            }
            File myGapii = GapiPaths.findTraceLibrary(abi);
            String component = pkg.myName + "/" + act.myName;
            this.myDevice.root();
            String enforced = GfxTracer.captureAdbShell(this.myDevice, "getenforce");
            if (ENFORCING_PATTERN.matcher(enforced).find()) {
                wasEnforcing = true;
            } else if (PERMISSIVE_PATTERN.matcher(enforced).find()) {
                wasEnforcing = false;
            } else {
                LOG.error("Unexpected getenforce result'" + enforced + "'");
                wasEnforcing = true;
            }
            if (wasEnforcing) {
                GfxTracer.captureAdbShell(this.myDevice, "setenforce 0");
            }
            try {
                String propName = "wrap." + pkg.myName;
                if (propName.length() > 31) {
                    propName = propName.substring(0, 31);
                }
                while (propName.endsWith(".")) {
                    propName = propName.substring(0, propName.length() - 1);
                }
                this.myDevice.pushFile(myGapii.getAbsolutePath(), PRELOAD_LIB);
                GfxTracer.captureAdbShell(this.myDevice, "setprop " + propName + " LD_PRELOAD=" + PRELOAD_LIB);
                try {
                    GfxTracer.captureAdbShell(this.myDevice, "am start -S -W -n " + component);
                    this.capture(options);
                }
                finally {
                    GfxTracer.captureAdbShell(this.myDevice, "setprop " + propName + " \"\"");
                }
            }
            finally {
                if (wasEnforcing) {
                    GfxTracer.captureAdbShell(this.myDevice, "setenforce 1");
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void capture(@NotNull Options options) {
        block7: {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "capture"));
            }
            boolean gotData = false;
            try {
                gotData = this.captureFromDevice(options);
                if (!gotData) break block7;
            }
            catch (RuntimeException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (gotData) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GfxTracer.this.myCaptureService.finalizeCaptureFileAsynchronous(GfxTracer.this.myCapture, new FutureCallback<Capture>(){

                                    public void onSuccess(Capture capture) {
                                        capture.getFile().refresh(true, false);
                                        GfxTracer.this.myCaptureService.notifyCaptureReady(capture);
                                    }

                                    public void onFailure(Throwable t) {
                                        LOG.error(t.getMessage());
                                    }
                                }, (Executor)MoreExecutors.sameThreadExecutor());
                            }
                        });
                        throw throwable;
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GfxTracer.this.myCaptureService.cancelCaptureFile(GfxTracer.this.myCapture);
                        }
                    });
                    throw throwable;
                }
            }
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private boolean captureFromDevice(@NotNull Options options) throws AdbCommandRejectedException, IOException, TimeoutException, InterruptedException {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "captureFromDevice"));
        }
        try {
            this.myDevice.createForward(9286, GAPII_ABSTRACT_PORT, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
            boolean bl = this.captureFromSocket("localhost", 9286, options);
            return bl;
        }
        finally {
            this.myDevice.removeForward(9286, GAPII_ABSTRACT_PORT, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean captureFromSocket(String host, int port, @NotNull Options options) throws IOException, InterruptedException {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "captureFromSocket"));
        }
        this.myListener.onAction("Connecting to application...");
        Socket socket = null;
        long lastUpdateMS = 0L;
        long total = 0L;
        byte[] buffer = new byte[4096];
        try {
            int len = 0;
            while (!this.myStopped) {
                if (socket == null) {
                    socket = new Socket(host, port);
                    socket.setSoTimeout(500);
                    GfxTracer.sendHeader(socket, options);
                }
                if ((len = GfxTracer.copyBlock(socket, this.myCapture, buffer)) > 0) {
                    if (total == 0L) {
                        this.myListener.onAction("Tracing...");
                    }
                    total += (long)len;
                    long nowMS = System.currentTimeMillis();
                    if (nowMS - lastUpdateMS <= 500L) continue;
                    this.myListener.onProgress(total);
                    lastUpdateMS = nowMS;
                    continue;
                }
                if (len >= 0) continue;
                socket.close();
                socket = null;
                if (total == 0L) {
                    Thread.sleep(500L);
                    continue;
                }
                this.stop();
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
        return total > 0L;
    }

    private static void sendHeader(@NotNull Socket socket, @NotNull Options options) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socket", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "sendHeader"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "sendHeader"));
        }
        int flags = 0;
        if (options.myDisablePrecompiledShaders) {
            flags |= 1;
        }
        OutputStream out = socket.getOutputStream();
        byte[] b = new byte[]{115, 112, 121, 48, 3, 0, 0, 0, (byte)(options.myObserveFrameFrequency >> 0), (byte)(options.myObserveFrameFrequency >> 8), (byte)(options.myObserveFrameFrequency >> 16), (byte)(options.myObserveFrameFrequency >> 24), (byte)(options.myObserveDrawFrequency >> 0), (byte)(options.myObserveDrawFrequency >> 8), (byte)(options.myObserveDrawFrequency >> 16), (byte)(options.myObserveDrawFrequency >> 24), (byte)(flags >> 0), (byte)(flags >> 8), (byte)(flags >> 16), (byte)(flags >> 24)};
        out.write(b);
        out.flush();
    }

    public void stop() {
        this.myStopped = true;
        this.myListener.onStopped();
    }

    private static int copyBlock(Socket socket, CaptureHandle capture, byte[] buffer) throws IOException {
        try {
            int len = socket.getInputStream().read(buffer);
            if (len > 0) {
                CaptureService.appendDataSynchronous(capture, buffer, 0, len);
            }
            return len;
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
    }

    @NotNull
    private static String captureAdbShell(IDevice device, String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand(command, (IShellOutputReceiver)receiver);
        String string = receiver.getOutput();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTracer", "captureAdbShell"));
        }
        return string;
    }

    public static interface Listener {
        public void onAction(@NotNull String var1);

        public void onProgress(long var1);

        public void onStopped();

        public void onError(@NotNull String var1);
    }

    public static class Options {
        public String myTraceName;
        public int myObserveFrameFrequency = 0;
        public int myObserveDrawFrequency = 0;
        public boolean myDisablePrecompiledShaders = false;

        public static Options fromRunConfiguration(@Nullable RunConfiguration config) {
            Options options = new Options();
            if (config != null && config instanceof AndroidRunConfigurationBase) {
                ProfilerState state = ((AndroidRunConfigurationBase)config).getProfilerState();
                options.myDisablePrecompiledShaders = state.GAPID_DISABLE_PCS;
            }
            return options;
        }
    }
}

