/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.editors.gfxtrace.controllers.MainController;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisConnection;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisFeatures;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisProcess;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientCache;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomMetadata;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.stringtable.Info;
import com.android.tools.idea.editors.gfxtrace.service.stringtable.StringTable;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Message;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    public static final String LOADING_CAPTURE = "Loading capture...";
    @NotNull
    public static final String SELECT_ATOM = "Select a frame or command";
    @NotNull
    public static final String SELECT_MEMORY = "Select a memory range in the command list";
    @NotNull
    public static final String SELECT_TEXTURE = "Select a texture";
    @NotNull
    public static final String NO_TEXTURES = "No textures have been created by this point";
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private static final int FETCH_SCHEMA_TIMEOUT_MS = 3000;
    private static final int FETCH_FEATURES_TIMEOUT_MS = 3000;
    private static final int FETCH_STRING_TABLE_TIMEOUT_MS = 3000;
    private static final int FETCH_REPLAY_DEVICE_TIMEOUT_MS = 3000;
    private static final int FETCH_REPLAY_DEVICE_RETRY_DELAY_MS = 3000;
    private static final int FETCH_REPLAY_DEVICE_MAX_RETRIES = 30;
    private static final int FETCH_TRACE_TIMEOUT_MS = 30000;
    @NotNull
    private static final String ERR_INIT_GAPIS_CONNECTION = "Error communicating with the graphics server";
    @NotNull
    private final Project myProject;
    @NotNull
    private TraceLoadingDecorator myLoadingDecorator;
    @NotNull
    private JBPanel myView;
    @NotNull
    private final ListeningExecutorService myExecutor;
    private GapisConnection myGapisConnection;
    private ServiceClient myClient;
    @NotNull
    private List<PathListener> myPathListeners;
    @NotNull
    private PathStore<Path> myLastActivatadPath;

    public static boolean isEnabled() {
        return true;
    }

    public GfxTraceEditor(@NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        this.myView = new JBPanel((LayoutManager)new BorderLayout());
        this.myExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.myPathListeners = new ArrayList<PathListener>();
        this.myLastActivatadPath = new PathStore();
        this.myProject = project;
        this.myLoadingDecorator = new TraceLoadingDecorator((JComponent)this.myView, (Disposable)this, 0);
        this.myLoadingDecorator.setLoadingText("Initializing GFX Trace System");
        this.myLoadingDecorator.startLoading(false);
        final JComponent mainUi = MainController.createUI(this);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!GfxTraceEditor.isEnabled()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("GFX Trace System not enabled on this host");
                    return;
                }
                if (!GapiPaths.isValid()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("GPU debugging SDK not installed");
                    return;
                }
                if (!GfxTraceEditor.this.connectToServer()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to connect to server");
                    return;
                }
                try {
                    GfxTraceEditor.this.myClient = new ServiceClientCache(GfxTraceEditor.this.myGapisConnection.createServiceClient(GfxTraceEditor.this.myExecutor), GfxTraceEditor.this.myExecutor);
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to talk to server");
                    return;
                }
                GapisFeatures features = GfxTraceEditor.this.myGapisConnection.getFeatures();
                String status = "";
                try {
                    status = "fetch schema";
                    GfxTraceEditor.this.fetchSchema();
                    status = "fetch feature list";
                    GfxTraceEditor.this.fetchFeatures(features);
                    if (features.hasRpcStringTables()) {
                        status = "fetch string table";
                        GfxTraceEditor.this.fetchStringTable();
                    }
                    status = "fetch replay device list";
                    GfxTraceEditor.this.fetchReplayDevice();
                    status = "load trace";
                    GfxTraceEditor.this.fetchTrace(file);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GfxTraceEditor.this.myView.add((Component)mainUi, (Object)"Center");
                            GfxTraceEditor.this.myLoadingDecorator.stopLoading();
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Failed to " + status, (Throwable)e);
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt(GfxTraceEditor.ERR_INIT_GAPIS_CONNECTION);
                    return;
                }
            }
        });
    }

    private void fetchSchema() throws ExecutionException, RpcException, TimeoutException {
        Message schema = (Message)Rpc.get(this.myClient.getSchema(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        LOG.info("Schema with " + schema.entities.length + " classes, " + schema.constants.length + " constant sets");
        int atoms = 0;
        for (Entity entity : schema.entities) {
            if (AtomMetadata.find(entity) != null) {
                ++atoms;
            }
            Dynamic.register((Entity)entity);
        }
        LOG.info("Schema with " + atoms + " atoms");
        for (Entity entity : schema.constants) {
            ConstantSet.register((ConstantSet)entity);
        }
    }

    private void fetchFeatures(GapisFeatures features) throws ExecutionException, RpcException, TimeoutException {
        String[] list = (String[])Rpc.get(this.myClient.getFeatures(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        features.setFeatureList(list);
        LOG.info("GAPIS features: " + list.toString());
    }

    private void fetchStringTable() throws ExecutionException, RpcException, TimeoutException {
        Info[] infos = (Info[])Rpc.get(this.myClient.getAvailableStringTables(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        if (infos.length == 0) {
            LOG.warn("No string tables available");
            return;
        }
        Info info = infos[0];
        StringTable table = (StringTable)Rpc.get(this.myClient.getStringTable(info), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
        table.setCurrent();
    }

    private void fetchReplayDevice() throws ExecutionException, RpcException, TimeoutException {
        for (int i = 0; i < 30; ++i) {
            DevicePath[] devices = (DevicePath[])Rpc.get(this.getClient().getDevices(), (long)3000L, (TimeUnit)TimeUnit.MILLISECONDS);
            if (devices != null && devices.length >= 1) {
                this.activatePath(devices[0], (Object)this);
                return;
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new RuntimeException("Couldn't find replay device");
    }

    private void fetchTrace(VirtualFile file) throws ExecutionException, RpcException, TimeoutException, IOException {
        ListenableFuture<CapturePath> captureF;
        if (file.getFileSystem().getProtocol().equals("file")) {
            LOG.info("Load gfxtrace in " + file.getPresentableName());
            if (file.getLength() == 0L) {
                throw new RuntimeException("Empty trace file");
            }
            captureF = this.myClient.loadCapture(file.getCanonicalPath());
        } else {
            byte[] data = file.contentsToByteArray();
            LOG.info("Upload " + data.length + " bytes of gfxtrace as " + file.getPresentableName());
            if (data.length == 0) {
                throw new RuntimeException("Empty trace file");
            }
            captureF = this.myClient.importCapture(file.getPresentableName(), data);
        }
        CapturePath path = (CapturePath)Rpc.get(captureF, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        if (path == null) {
            throw new RuntimeException("Invalid capture file " + file.getPresentableName());
        }
        this.activatePath(path, (Object)this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getProject"));
        }
        return project;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myLoadingDecorator.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("GfxTraceView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getName"));
        }
        return "GfxTraceView";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activatePath(final @NotNull Path path, final Object source) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "activatePath"));
        }
        PathStore<Path> pathStore = this.myLastActivatadPath;
        synchronized (pathStore) {
            if (!this.myLastActivatadPath.update(path)) {
                return;
            }
        }
        final PathListener.PathEvent event = new PathListener.PathEvent(path, source);
        Runnable eventDispatch = new Runnable(){

            @Override
            public void run() {
                LOG.info("Activate path " + path + ", source: " + source.getClass().getName());
                for (PathListener listener : GfxTraceEditor.this.myPathListeners) {
                    listener.notifyPath(event);
                }
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            eventDispatch.run();
        } else {
            application.invokeLater(eventDispatch);
        }
    }

    public void addPathListener(@NotNull PathListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPathListener"));
        }
        this.myPathListeners.add(listener);
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public ServiceClient getClient() {
        ServiceClient serviceClient = this.myClient;
        if (serviceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getClient"));
        }
        return serviceClient;
    }

    @NotNull
    public ListeningExecutorService getExecutor() {
        ListeningExecutorService listeningExecutorService = this.myExecutor;
        if (listeningExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getExecutor"));
        }
        return listeningExecutorService;
    }

    public void dispose() {
        this.shutdown();
    }

    private boolean connectToServer() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        this.myGapisConnection = GapisProcess.connect();
        return this.myGapisConnection.isConnected();
    }

    private void setLoadingErrorTextOnEdt(final @NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setLoadingErrorTextOnEdt"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GfxTraceEditor.this.myLoadingDecorator.setErrorMessage(error);
            }
        });
    }

    private void shutdown() {
        if (this.myGapisConnection != null) {
            this.myGapisConnection.close();
            this.myGapisConnection = null;
        }
        this.myExecutor.shutdown();
    }

    private static class TraceLoadingDecorator
    extends LoadingDecorator {
        private JPanel iconPanel;

        public TraceLoadingDecorator(JComponent content, Disposable parent, int startDelayMs) {
            super(content, parent, startDelayMs);
        }

        protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
            NonOpaquePanel result = super.customizeLoadingLayer(parent, text, icon);
            result.remove(0);
            this.iconPanel = new JPanel();
            result.add((Component)this.iconPanel, 0);
            this.iconPanel.add((Component)icon);
            return result;
        }

        public void setErrorMessage(String text) {
            this.iconPanel.removeAll();
            this.iconPanel.add((Component)new JBLabel(AllIcons.General.ErrorDialog));
            this.setLoadingText(text);
            this.startLoading(false);
        }
    }
}

