/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.ResolveTypedIntegerCommand;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.IntegerType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class AndroidTypedIntegerRenderer
extends NodeRendererImpl {
    private static final String ID = "android.resource.renderer";

    public AndroidTypedIntegerRenderer() {
        super("Android Typed Integer");
        this.myProperties.setEnabled(true);
    }

    public String getUniqueId() {
        return ID;
    }

    public boolean isApplicable(Type type) {
        return type != null && type instanceof IntegerType;
    }

    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        Value value = descriptor.getValue();
        BatchEvaluator.getBatchEvaluator((DebugProcess)evaluationContext.getDebugProcess()).invoke((ToStringCommand)new ResolveTypedIntegerCommand(descriptor, evaluationContext, value, listener));
        return value.toString();
    }

    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }

    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return null;
    }
}

