/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.charset;

import com.intellij.lang.properties.charset.Native2AsciiCharsetDecoder;
import com.intellij.lang.properties.charset.Native2AsciiCharsetEncoder;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Native2AsciiCharset
extends Charset {
    private static final String[] ALIASES = new String[0];
    private final Charset myBaseCharset;
    private static final String NAME_PREFIX = "NATIVE_TO_ASCII_";
    private static final String DEFAULT_ENCODING_NAME = "ISO-8859-1";
    private static final ConcurrentMap<String, Native2AsciiCharset> cache = new ConcurrentHashMap<String, Native2AsciiCharset>();

    private Native2AsciiCharset(String canonicalName) {
        super(canonicalName, ALIASES);
        String baseCharsetName = canonicalName.substring(NAME_PREFIX.length());
        Charset baseCharset = null;
        try {
            baseCharset = Charset.forName(baseCharsetName);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        this.myBaseCharset = baseCharset == null ? Charset.forName(DEFAULT_ENCODING_NAME) : baseCharset;
    }

    @Override
    public String displayName() {
        return this.getBaseCharset().displayName();
    }

    @Override
    public boolean contains(Charset cs) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Native2AsciiCharsetDecoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Native2AsciiCharsetEncoder(this);
    }

    public Charset getBaseCharset() {
        return this.myBaseCharset;
    }

    public static String makeNative2AsciiEncodingName(String baseCharsetName) {
        if (baseCharsetName == null) {
            baseCharsetName = DEFAULT_ENCODING_NAME;
        }
        return NAME_PREFIX + baseCharsetName;
    }

    public static Charset forName(String charsetName) {
        if (charsetName.startsWith(NAME_PREFIX)) {
            Native2AsciiCharset prev;
            Native2AsciiCharset cached = (Native2AsciiCharset)cache.get(charsetName);
            if (cached == null && (prev = cache.putIfAbsent(charsetName, cached = new Native2AsciiCharset(charsetName))) != null) {
                cached = prev;
            }
            return cached;
        }
        return null;
    }

    public static Charset wrap(Charset baseCharset) {
        return Native2AsciiCharset.forName(NAME_PREFIX + baseCharset.name());
    }

    public static Charset nativeToBaseCharset(Charset charset) {
        if (charset instanceof Native2AsciiCharset) {
            return ((Native2AsciiCharset)charset).getBaseCharset();
        }
        return charset;
    }
}

