/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.Escaper;
import java.util.HashMap;
import java.util.Map;

public final class SourceCodeEscapers {
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private static final Escaper JAVA_CHAR_ESCAPER;
    private static final Escaper JAVA_CHAR_ESCAPER_WITH_OCTAL;
    private static final Escaper JAVA_STRING_ESCAPER_WITH_OCTAL;
    private static final Escaper JAVA_STRING_UNICODE_ESCAPER;

    private SourceCodeEscapers() {
    }

    public static Escaper javaCharEscaper() {
        return JAVA_CHAR_ESCAPER;
    }

    public static Escaper javaCharEscaperWithOctal() {
        return JAVA_CHAR_ESCAPER_WITH_OCTAL;
    }

    public static Escaper javaStringEscaperWithOctal() {
        return JAVA_STRING_ESCAPER_WITH_OCTAL;
    }

    public static Escaper javaStringUnicodeEscaper() {
        return JAVA_STRING_UNICODE_ESCAPER;
    }

    private static char[] asUnicodeHexEscape(char c) {
        char[] r = new char[6];
        r[0] = 92;
        r[1] = 117;
        r[5] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[4] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[3] = HEX_DIGITS[c & 0xF];
        c = (char)(c >>> 4);
        r[2] = HEX_DIGITS[c & 0xF];
        return r;
    }

    private static char[] asOctalEscape(char c) {
        char[] r = new char[4];
        r[0] = 92;
        r[3] = HEX_DIGITS[c & 7];
        c = (char)(c >>> 3);
        r[2] = HEX_DIGITS[c & 7];
        c = (char)(c >>> 3);
        r[1] = HEX_DIGITS[c & 3];
        return r;
    }

    static {
        HashMap<Character, String> javaMap = new HashMap<Character, String>();
        javaMap.put(Character.valueOf('\b'), "\\b");
        javaMap.put(Character.valueOf('\f'), "\\f");
        javaMap.put(Character.valueOf('\n'), "\\n");
        javaMap.put(Character.valueOf('\r'), "\\r");
        javaMap.put(Character.valueOf('\t'), "\\t");
        javaMap.put(Character.valueOf('\"'), "\\\"");
        javaMap.put(Character.valueOf('\\'), "\\\\");
        JAVA_STRING_ESCAPER_WITH_OCTAL = new JavaCharEscaperWithOctal(javaMap);
        javaMap.put(Character.valueOf('\''), "\\'");
        JAVA_CHAR_ESCAPER = new JavaCharEscaper(javaMap);
        JAVA_CHAR_ESCAPER_WITH_OCTAL = new JavaCharEscaperWithOctal(javaMap);
        JAVA_STRING_UNICODE_ESCAPER = new CharEscaper(){

            @Override
            protected char[] escape(char c) {
                if (c < '\u0080') {
                    return null;
                }
                return SourceCodeEscapers.asUnicodeHexEscape(c);
            }
        };
    }

    private static class JavaCharEscaperWithOctal
    extends ArrayBasedCharEscaper {
        JavaCharEscaperWithOctal(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            if (c < '\u0100') {
                return SourceCodeEscapers.asOctalEscape(c);
            }
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }

    private static class JavaCharEscaper
    extends ArrayBasedCharEscaper {
        JavaCharEscaper(Map<Character, String> replacements) {
            super(replacements, ' ', '~');
        }

        @Override
        protected char[] escapeUnsafe(char c) {
            return SourceCodeEscapers.asUnicodeHexEscape(c);
        }
    }
}

