/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class MathExpr
extends Expr {
    final String mOp;

    MathExpr(Expr left, String op, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return MathExpr.join(this.getLeft().getUniqueKey(), this.mOp, this.getRight().getUniqueKey());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if ("+".equals(this.mOp) && (this.getLeft().getResolvedType().isString() || this.getRight().getResolvedType().isString())) {
            return modelAnalyzer.findClass(String.class);
        }
        return modelAnalyzer.findCommonParentOf(this.getLeft().getResolvedType(), this.getRight().getResolvedType());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("(", this.getLeft().toCode()).app(") ").app(this.mOp).app(" (", this.getRight().toCode()).app(")");
    }

    @Override
    public String getInvertibleError() {
        if (this.mOp.equals("%")) {
            return "The modulus operator (%) is not supported in two-way binding.";
        }
        if (this.getResolvedType().isString()) {
            return "String concatenation operator (+) is not supported in two-way binding.";
        }
        if (!this.getLeft().isDynamic()) {
            return this.getRight().getInvertibleError();
        }
        if (!this.getRight().isDynamic()) {
            return this.getLeft().getInvertibleError();
        }
        return "Arithmetic operator " + this.mOp + " is not supported with two dynamic expressions.";
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        MathExpr newValue;
        Expr left = this.getLeft();
        Expr right = this.getRight();
        Preconditions.check(left.isDynamic() ^ right.isDynamic(), "Two-way binding of a math operations requires A signle dynamic expression. Neither or both sides are dynamic: (%s) %s (%s)", left, this.mOp, right);
        Expr constExpr = (left.isDynamic() ? right : left).cloneToModel(model);
        switch (this.mOp.charAt(0)) {
            case '+': {
                newValue = model.math(value, "-", constExpr);
                break;
            }
            case '*': {
                newValue = model.math(value, "/", constExpr);
                break;
            }
            case '-': {
                if (!left.isDynamic()) {
                    newValue = model.math(constExpr, "-", value);
                    break;
                }
                newValue = model.math(value, "+", constExpr);
                break;
            }
            case '/': {
                if (!left.isDynamic()) {
                    newValue = model.math(constExpr, "/", value);
                    break;
                }
                newValue = model.math(value, "*", constExpr);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid math operation is not invertible: " + this.mOp);
            }
        }
        Expr varExpr = left.isDynamic() ? left : right;
        return varExpr.generateInverse(model, newValue, bindingClassName);
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.math(this.getLeft().cloneToModel(model), this.mOp, this.getRight().cloneToModel(model));
    }

    @Override
    public String toString() {
        return "(" + this.getLeft() + ") " + this.mOp + " (" + this.getRight() + ")";
    }
}

