/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.BindingTarget;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.LambdaExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.LocationScopeProvider;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.store.Location;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.LayoutBinderWriterKt;
import java.util.List;
import java.util.Map;

public class Binding
implements LocationScopeProvider {
    private final String mName;
    private Expr mExpr;
    private final BindingTarget mTarget;
    private SetterStore.BindingSetterCall mSetterCall;

    public Binding(BindingTarget target, String name, Expr expr) {
        this(target, name, expr, null);
    }

    public Binding(BindingTarget target, String name, Expr expr, SetterStore.BindingSetterCall setterCall) {
        this.mTarget = target;
        this.mName = name;
        this.mExpr = expr;
        this.mSetterCall = setterCall;
    }

    @Override
    public List<Location> provideScopeLocation() {
        return this.mExpr.getLocations();
    }

    public void resolveListeners() {
        ModelClass listenerParameter = Binding.getListenerParameter(this.mTarget, this.mName, this.mExpr.getModel());
        Expr listenerExpr = this.mExpr.resolveListeners(listenerParameter, null);
        if (listenerExpr != this.mExpr) {
            listenerExpr.setBindingExpression(true);
            this.mExpr = listenerExpr;
        }
    }

    public void resolveCallbackParams() {
        if (!(this.mExpr instanceof LambdaExpr)) {
            return;
        }
        LambdaExpr lambdaExpr = (LambdaExpr)this.mExpr;
        ModelClass listener = Binding.getListenerParameter(this.mTarget, this.mName, this.mExpr.getModel());
        Preconditions.checkNotNull(listener, "Cannot find the setter for attribute '%s' with parameter type %s on %s.", this.mName, "lambda", this.getTarget().getInterfaceType());
        List<ModelMethod> abstractMethods = listener.getAbstractMethods();
        int numberOfAbstractMethods = abstractMethods.size();
        if (numberOfAbstractMethods != 1) {
            L.e("Cannot find the proper callback class for %s. Tried %s but it has %d abstract methods, should have %d abstract methods.", this.mName, listener.getCanonicalName(), numberOfAbstractMethods, 1);
        }
        ModelMethod method = abstractMethods.get(0);
        int argCount = lambdaExpr.getCallbackExprModel().getArgCount();
        if (argCount != 0 && argCount != method.getParameterTypes().length) {
            L.e("The callback %s#%s has %s methods but the lambda defined has %d. It should have either 0 or equal number of parameters.", listener.getCanonicalName(), method.getName(), method.getParameterTypes().length, argCount);
        }
        lambdaExpr.setup(listener, method, this.mExpr.getModel().obtainCallbackId());
    }

    public void resolveTwoWayExpressions() {
        Expr expr = this.mExpr.resolveTwoWayExpressions(null);
        if (expr != this.mExpr) {
            this.mExpr = expr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SetterStore.BindingSetterCall getSetterCall() {
        if (this.mSetterCall == null) {
            try {
                Scope.enter(this.getTarget());
                Scope.enter(this);
                this.resolveSetterCall();
                if (this.mSetterCall == null) {
                    L.e("Cannot find the setter for attribute '%s' with parameter type %s on %s.", this.mName, this.mExpr.getResolvedType(), this.getTarget().getInterfaceType());
                }
            }
            finally {
                Scope.exit();
                Scope.exit();
            }
        }
        return this.mSetterCall;
    }

    private void resolveSetterCall() {
        ModelClass viewType = this.mTarget.getResolvedType();
        if (viewType != null && viewType.extendsViewStub()) {
            if (Binding.isListenerAttribute(this.mName)) {
                ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
                ModelClass viewStubProxy = modelAnalyzer.findClass("android.databinding.ViewStubProxy", null);
                this.mSetterCall = SetterStore.get(modelAnalyzer).getSetterCall(this.mName, viewStubProxy, this.mExpr.getResolvedType(), this.mExpr.getModel().getImports());
            } else {
                this.mSetterCall = Binding.isViewStubAttribute(this.mName) ? new ViewStubDirectCall(this.mName, viewType, this.mExpr.getResolvedType(), this.mExpr.getModel().getImports()) : new ViewStubSetterCall(this.mName);
            }
        } else {
            SetterStore setterStore = SetterStore.get(ModelAnalyzer.getInstance());
            this.mSetterCall = setterStore.getSetterCall(this.mName, viewType, this.mExpr.getResolvedType(), this.mExpr.getModel().getImports());
        }
    }

    private static ModelClass getListenerParameter(BindingTarget target, String name, ExprModel model) {
        SetterStore.SetterCall setterCall;
        ModelClass viewType = target.getResolvedType();
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        ModelClass objectParameter = modelAnalyzer.findClass(Object.class);
        SetterStore setterStore = SetterStore.get(modelAnalyzer);
        if (viewType != null && viewType.extendsViewStub()) {
            if (Binding.isListenerAttribute(name)) {
                ModelClass viewStubProxy = modelAnalyzer.findClass("android.databinding.ViewStubProxy", null);
                setterCall = SetterStore.get(modelAnalyzer).getSetterCall(name, viewStubProxy, objectParameter, model.getImports());
            } else {
                setterCall = Binding.isViewStubAttribute(name) ? null : new ViewStubSetterCall(name);
            }
        } else {
            setterCall = setterStore.getSetterCall(name, viewType, objectParameter, model.getImports());
        }
        if (setterCall != null) {
            return setterCall.getParameterTypes()[0];
        }
        List<SetterStore.MultiAttributeSetter> setters = setterStore.getMultiAttributeSetterCalls(new String[]{name}, viewType, new ModelClass[]{modelAnalyzer.findClass(Object.class)});
        if (setters.isEmpty()) {
            return null;
        }
        return setters.get(0).getParameterTypes()[0];
    }

    public BindingTarget getTarget() {
        return this.mTarget;
    }

    public String toJavaCode(String targetViewName, String bindingComponent) {
        String currentValue = this.requiresOldValue() ? "this." + LayoutBinderWriterKt.getOldValueName(this.mExpr) : null;
        String argCode = this.getExpr().toCode().generate();
        return this.getSetterCall().toJava(bindingComponent, targetViewName, currentValue, argCode);
    }

    public String getBindingAdapterInstanceClass() {
        return this.getSetterCall().getBindingAdapterInstanceClass();
    }

    public Expr[] getComponentExpressions() {
        return new Expr[]{this.mExpr};
    }

    public boolean requiresOldValue() {
        return this.getSetterCall().requiresOldValue();
    }

    public int getMinApi() {
        return this.getSetterCall().getMinApi();
    }

    public String getName() {
        return this.mName;
    }

    public Expr getExpr() {
        return this.mExpr;
    }

    private static boolean isViewStubAttribute(String name) {
        return "android:inflatedId".equals(name) || "android:layout".equals(name) || "android:visibility".equals(name) || "android:layoutInflater".equals(name);
    }

    private static boolean isListenerAttribute(String name) {
        return "android:onInflate".equals(name) || "android:onInflateListener".equals(name);
    }

    private static class ViewStubDirectCall
    extends SetterStore.SetterCall {
        private final SetterStore.SetterCall mWrappedCall;

        public ViewStubDirectCall(String name, ModelClass viewType, ModelClass resolvedType, Map<String, String> imports) {
            this.mWrappedCall = SetterStore.get(ModelAnalyzer.getInstance()).getSetterCall(name, viewType, resolvedType, imports);
            if (this.mWrappedCall == null) {
                L.e("Cannot find the setter for attribute '%s' on %s with parameter type %s.", name, viewType, resolvedType);
            }
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String converted) {
            return "if (!" + viewExpression + ".isInflated()) " + this.mWrappedCall.toJava(componentExpression, viewExpression + ".getViewStub()", null, converted);
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String converted) {
            return null;
        }

        @Override
        public int getMinApi() {
            return 0;
        }

        @Override
        public boolean requiresOldValue() {
            return false;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{ModelAnalyzer.getInstance().findClass(Object.class)};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return this.mWrappedCall.getBindingAdapterInstanceClass();
        }
    }

    private static class ViewStubSetterCall
    extends SetterStore.SetterCall {
        private final String mName;

        public ViewStubSetterCall(String name) {
            this.mName = name.substring(name.lastIndexOf(58) + 1);
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String converted) {
            return "if (" + viewExpression + ".isInflated()) " + viewExpression + ".getBinding().setVariable(BR." + this.mName + ", " + converted + ")";
        }

        @Override
        protected String toJavaInternal(String componentExpression, String viewExpression, String oldValue, String converted) {
            return null;
        }

        @Override
        public int getMinApi() {
            return 0;
        }

        @Override
        public boolean requiresOldValue() {
            return false;
        }

        @Override
        public ModelClass[] getParameterTypes() {
            return new ModelClass[]{ModelAnalyzer.getInstance().findClass(Object.class)};
        }

        @Override
        public String getBindingAdapterInstanceClass() {
            return null;
        }
    }
}

