/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import java.awt.Container;
import java.io.File;
import java.io.IOException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.RepositoryService;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u0005\u0016\u0011kA\u0001\t\u0003\u0015BAa\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001d\u0001"}, strings={"Lorg/jetbrains/settingsRepository/git/GitRepositoryService;", "Lorg/jetbrains/settingsRepository/RepositoryService;", "()V", "isValidRepository", "", "file", "Ljava/io/File;"}, moduleName="settings-repository")
public final class GitRepositoryService
implements RepositoryService {
    @Override
    public boolean isValidRepository(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (new File(file, ".git").exists()) {
            return true;
        }
        try {
            ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(file)).setMustExist(true)).build();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean checkUrl(@NotNull String uriString, @Nullable Container messageParent) {
        Intrinsics.checkParameterIsNotNull((Object)uriString, (String)"uriString");
        return RepositoryService.DefaultImpls.checkUrl(this, uriString, messageParent);
    }

    @Override
    public boolean checkFileRepo(@NotNull String url, @NotNull Container messageParent) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)messageParent, (String)"messageParent");
        return RepositoryService.DefaultImpls.checkFileRepo(this, url, messageParent);
    }
}

