/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jgit.dirCache;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jgit.dirCache.DirCacheEditorKt;
import org.jetbrains.jgit.dirCache.PathEditBase;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K1!1\u0002#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/jgit/dirCache/AddFile;", "Lorg/jetbrains/jgit/dirCache/PathEditBase;", "pathString", "", "(Ljava/lang/String;)V", "apply", "", "entry", "Lorg/eclipse/jgit/dircache/DirCacheEntry;", "repository", "Lorg/eclipse/jgit/lib/Repository;"}, moduleName="settings-repository")
public final class AddFile
extends PathEditBase {
    private final String pathString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NotNull DirCacheEntry entry, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        File file = new File(repository2.getWorkTree(), this.pathString);
        entry.setFileMode(FileMode.REGULAR_FILE);
        long length = file.length();
        entry.setLength(length);
        entry.setLastModified(file.lastModified());
        FileInputStream input = new FileInputStream(file);
        ObjectInserter inserter = repository2.newObjectInserter();
        try {
            entry.setObjectId((AnyObjectId)inserter.insert(3, length, (InputStream)input));
            inserter.flush();
        }
        finally {
            inserter.close();
            input.close();
        }
    }

    public AddFile(@NotNull String pathString) {
        Intrinsics.checkParameterIsNotNull((Object)pathString, (String)"pathString");
        super(DirCacheEditorKt.access$encodePath(pathString));
        this.pathString = pathString;
    }
}

