/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;

public final class GitRefNameValidator
implements InputValidator {
    private static final GitRefNameValidator INSTANCE = new GitRefNameValidator();
    private static String CONTROL_CHARS;
    private static final Pattern ILLEGAL;

    public static GitRefNameValidator getInstance() {
        return INSTANCE;
    }

    private GitRefNameValidator() {
    }

    public boolean checkInput(String inputString) {
        return !StringUtil.isEmptyOrSpaces((String)inputString) && !ILLEGAL.matcher(inputString).find() && !inputString.startsWith("-");
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        sb.append('\u007f');
        sb.append("]");
        CONTROL_CHARS = sb.toString();
        ILLEGAL = Pattern.compile("(^\\.)|[ ~:\\^\\?\\*\\[\\\\]+|(@\\{)+|(\\.\\.)+|(([\\./]|\\.lock)$)|" + CONTROL_CHARS);
    }
}

