/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import git4idea.GitLocalBranch;
import org.jetbrains.annotations.NotNull;

public abstract class GitPushSource
implements PushSource {
    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/push/GitPushSource", "create"));
        }
        OnBranch onBranch = new OnBranch(branch);
        if (onBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSource", "create"));
        }
        return onBranch;
    }

    @NotNull
    public static GitPushSource create(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/push/GitPushSource", "create"));
        }
        DetachedHead detachedHead = new DetachedHead(revision);
        if (detachedHead == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSource", "create"));
        }
        return detachedHead;
    }

    @NotNull
    abstract GitLocalBranch getBranch();

    private static class DetachedHead
    extends GitPushSource {
        @NotNull
        private final String myRevision;

        public DetachedHead(@NotNull String revision) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "git4idea/push/GitPushSource$DetachedHead", "<init>"));
            }
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            String string = DvcsUtil.getShortHash((String)this.myRevision);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSource$DetachedHead", "getPresentation"));
            }
            return string;
        }

        @Override
        @NotNull
        GitLocalBranch getBranch() {
            throw new IllegalStateException("Push is not allowed from detached HEAD");
        }
    }

    private static class OnBranch
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;

        private OnBranch(@NotNull GitLocalBranch branch) {
            if (branch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/push/GitPushSource$OnBranch", "<init>"));
            }
            this.myBranch = branch;
        }

        @NotNull
        public String getPresentation() {
            String string = this.myBranch.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSource$OnBranch", "getPresentation"));
            }
            return string;
        }

        @Override
        @NotNull
        GitLocalBranch getBranch() {
            GitLocalBranch gitLocalBranch = this.myBranch;
            if (gitLocalBranch == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushSource$OnBranch", "getBranch"));
            }
            return gitLocalBranch;
        }
    }
}

