/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseLineListener;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRebaseActionBase
extends GitRepositoryAction {
    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, final List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitRebaseActionBase", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitRebaseActionBase", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitRebaseActionBase", "perform"));
        }
        final GitLineHandler h = this.createHandler(project, gitRoots, defaultRoot);
        if (h == null) {
            return;
        }
        final VirtualFile root = h.workingDirectoryFile();
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        final GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(service, project, root, h);
        final GitRebaseLineListener resultListener = new GitRebaseLineListener();
        h.addLineListener(resultListener);
        this.configureEditor(editor);
        affectedRoots.add(root);
        service.configureHandler(h, editor.getHandlerNo());
        new Task.Backgroundable(project, GitBundle.getString("rebasing.title"), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitRebaseActionBase$1", "run"));
                }
                AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
                try {
                    GitCommandResult result = ((Git)ServiceManager.getService(Git.class)).runCommand(h);
                    editor.close();
                    GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
                    manager.updateRepository(root);
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
                    GitRebaseActionBase.notifyAboutResult(result, resultListener, editor.wasNoopSituationDetected(), exceptions, project);
                }
                finally {
                    DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
                }
            }
        }.queue();
    }

    private static void notifyAboutResult(@NotNull GitCommandResult commandResult, @NotNull GitRebaseLineListener resultListener, boolean noopSituation, @NotNull List<VcsException> exceptions, @NotNull Project project) {
        String messageId;
        if (commandResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandResult", "git4idea/actions/GitRebaseActionBase", "notifyAboutResult"));
        }
        if (resultListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultListener", "git4idea/actions/GitRebaseActionBase", "notifyAboutResult"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "git4idea/actions/GitRebaseActionBase", "notifyAboutResult"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitRebaseActionBase", "notifyAboutResult"));
        }
        GitRebaseLineListener.Result result = resultListener.getResult();
        String message = null;
        boolean isError = true;
        switch (result.status) {
            case CONFLICT: {
                messageId = "rebase.result.conflict";
                break;
            }
            case ERROR: {
                messageId = "rebase.result.error";
                message = commandResult.getErrorOutputAsHtmlString();
                break;
            }
            case CANCELLED: {
                exceptions.clear();
                return;
            }
            case EDIT: {
                isError = false;
                messageId = "rebase.result.amend";
                break;
            }
            case FINISHED: {
                isError = false;
                messageId = "rebase.result.success";
                if (!noopSituation) break;
                message = "Current branch was reset to the base branch";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported rebase result: " + (Object)((Object)result.status));
            }
        }
        String title = GitBundle.message(messageId + ".title", new Object[0]);
        if (message == null) {
            message = GitBundle.message(messageId, result.current, result.total);
        }
        if (isError) {
            VcsNotifier.getInstance((Project)project).notifyError(title, message);
        } else {
            VcsNotifier.getInstance((Project)project).notifySuccess(title, message);
        }
    }

    protected void configureEditor(GitInteractiveRebaseEditorHandler editor) {
    }

    @Nullable
    protected abstract GitLineHandler createHandler(Project var1, List<VirtualFile> var2, VirtualFile var3);
}

