/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.util;

import com.google.appindexing.util.ManifestUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeepLinkUtils {
    private static final String TAG_ACTION = "action";
    private static final String TAG_CATEGORY = "category";
    private static final String ACTION_VIEW = "android.intent.action.VIEW";
    private static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    private static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";

    @NotNull
    public static List<String> getAllDeepLinks(@NotNull XmlTag root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/google/appindexing/util/DeepLinkUtils", "getAllDeepLinks"));
        }
        List<XmlTag> intentFilters = ManifestUtils.searchXmlTagsByName(root, "intent-filter");
        ArrayList deepLinks = Lists.newArrayList();
        for (XmlTag intentFilter : intentFilters) {
            String deepLink = DeepLinkUtils.getDeepLinkFromIntentFilter(intentFilter);
            if (deepLink == null) continue;
            deepLinks.add(deepLink);
        }
        ArrayList arrayList = deepLinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/util/DeepLinkUtils", "getAllDeepLinks"));
        }
        return arrayList;
    }

    @Nullable
    private static String getDeepLinkFromIntentFilter(@NotNull XmlTag intentFilter) {
        if (intentFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentFilter", "com/google/appindexing/util/DeepLinkUtils", "getDeepLinkFromIntentFilter"));
        }
        List<XmlTag> actions = ManifestUtils.searchXmlTagsByName(intentFilter, TAG_ACTION);
        boolean hasActionView = false;
        for (XmlTag action : actions) {
            String name = action.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name == null || !name.equals(ACTION_VIEW)) continue;
            hasActionView = true;
            break;
        }
        if (!hasActionView) {
            return null;
        }
        List<XmlTag> categories = ManifestUtils.searchXmlTagsByName(intentFilter, TAG_CATEGORY);
        boolean hasDefaultCategory = false;
        boolean hasBrowsableCategory = false;
        for (XmlTag category : categories) {
            String name = category.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (name != null && name.equals(CATEGORY_DEFAULT)) {
                hasDefaultCategory = true;
                continue;
            }
            if (name == null || !name.equals(CATEGORY_BROWSABLE)) continue;
            hasBrowsableCategory = true;
        }
        if (!hasDefaultCategory || !hasBrowsableCategory) {
            return null;
        }
        List<XmlTag> datas = ManifestUtils.searchXmlTagsByName(intentFilter, "data");
        String scheme = null;
        String host = null;
        String pathPrefix = null;
        String path = null;
        for (XmlTag data : datas) {
            if (scheme == null) {
                scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            }
            if (host == null) {
                host = data.getAttributeValue("host", "http://schemas.android.com/apk/res/android");
            }
            if (pathPrefix == null) {
                pathPrefix = data.getAttributeValue("pathPrefix", "http://schemas.android.com/apk/res/android");
            }
            if (path != null) continue;
            path = data.getAttributeValue("path", "http://schemas.android.com/apk/res/android");
        }
        if (scheme != null) {
            StringBuilder buf = new StringBuilder(scheme);
            buf.append("://");
            if (host != null) {
                buf.append(host);
                if (path != null && path.startsWith("/")) {
                    buf.append(path);
                } else if (pathPrefix != null && pathPrefix.startsWith("/")) {
                    buf.append(pathPrefix);
                }
            }
            return buf.toString();
        }
        return null;
    }
}

