/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.ui;

import com.android.tools.idea.stats.UsageTracker;
import com.google.api.client.util.Lists;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleClient;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.fetchasgoogle.SupportedLanguage;
import com.google.appindexing.util.DeepLinkUtils;
import com.google.appindexing.util.ManifestUtils;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AppIndexingDialog
extends DialogWrapper {
    private static final String DIALOG_TITLE = "Google App Indexing Test";
    private static final String MODULE_NOT_SPECIFIED_WARNING = "Module not provided";
    private static final String DEEP_LINK_NOT_SPECIFIED_WARNING = "URL not provided";
    private static final String LANGUAGE_NOT_SPECIFIED_WARNING = "Language not provided";
    private static final String NO_LOGIN_WARNING = "Sign in with your Google account to test App Indexing";
    private JComboBox myLanguageComboBox;
    private JPanel myPanel;
    private JComboBox myModulesComboBox;
    private JLabel myWarningLabel;
    private JButton myLoginButton;
    private TextFieldWithHistory myDeepLinkInputField;
    private JPanel myWarningPanel;
    private JLabel myWarningTitle;
    private final SortedComboBoxModel<Module> myModules;
    private final SortedComboBoxModel<SupportedLanguage.Language> myLanguages;
    private Project myProject;

    private static final Logger getLog() {
        return Logger.getInstance(FetchAsGoogleTask.class);
    }

    public AppIndexingDialog(@NotNull Project project) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/appindexing/ui/AppIndexingDialog", "<init>"));
        }
        super(project);
        this.$$$setupUI$$$();
        this.myModules = new SortedComboBoxModel((Comparator)new Comparator<Module>(){

            @Override
            public int compare(Module module, Module module1) {
                return module.getName().compareToIgnoreCase(module1.getName());
            }
        });
        this.myLanguages = new SortedComboBoxModel((Comparator)new Comparator<SupportedLanguage.Language>(){

            @Override
            public int compare(SupportedLanguage.Language language0, SupportedLanguage.Language language1) {
                return language0.getName().compareTo(language1.getName());
            }
        });
        this.init();
        this.setTitle(DIALOG_TITLE);
        this.myProject = project;
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!AppIndexingDialog.isModuleAccepted(module)) continue;
            this.myModules.add((Object)module);
        }
        if (this.myModules.getSize() != 0) {
            this.myModules.setSelectedItem(this.myModules.getElementAt(0));
        }
        this.myModulesComboBox.setModel(this.myModules);
        this.myModulesComboBox.setRenderer(new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setIcon(ModuleType.get((Module)value).getIcon());
                    this.setText(value.getName());
                } else {
                    this.setText("<no module>");
                }
            }
        });
        this.myModulesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppIndexingDialog.this.myDeepLinkInputField.setHistory(AppIndexingDialog.this.getDeepLinks());
            }
        });
        this.myDeepLinkInputField.setEditor((ComboBoxEditor)new MyComboBoxEditor());
        this.myDeepLinkInputField.setHistorySize(-1);
        this.myDeepLinkInputField.setHistory(this.getDeepLinks());
        new ComboboxSpeedSearch(this.myLanguageComboBox){

            protected String getElementText(Object element) {
                if (element instanceof SupportedLanguage.Language) {
                    return ((SupportedLanguage.Language)element).getDisplayName();
                }
                if (element == null) {
                    return "<no language>";
                }
                return super.getElementText(element);
            }
        };
        this.myLanguages.addAll(SupportedLanguage.getSupportedLanguage());
        this.myLanguageComboBox.setModel(this.myLanguages);
        this.myLanguageComboBox.setSelectedIndex(0);
        this.myLanguageComboBox.setRenderer(new ListCellRendererWrapper<SupportedLanguage.Language>(){

            public void customize(JList list, SupportedLanguage.Language value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getDisplayName());
                } else {
                    this.setText("<no language>");
                }
            }
        });
        this.myLanguageComboBox.setSelectedItem(SupportedLanguage.getDefaultLanguage());
        this.myLoginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AppIndexingDialog.this.myLoginButton.setEnabled(false);
                    GoogleLogin.promptToLogIn(null, (IGoogleLoginCompletedCallback)new IGoogleLoginCompletedCallback(){

                        public void onLoginCompleted() {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AppIndexingDialog.this.verifyInput();
                                }
                            }, ModalityState.any());
                        }
                    });
                }
                catch (Exception ex) {
                    AppIndexingDialog.getLog().warn("Login fail", (Throwable)ex);
                }
            }
        });
        this.myWarningTitle.setIcon(AllIcons.General.BalloonError);
        this.myWarningTitle.setFont(this.myWarningTitle.getFont().deriveFont(1));
        this.myWarningPanel.setVisible(false);
        this.doValidate();
    }

    private static boolean isModuleAccepted(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/google/appindexing/ui/AppIndexingDialog", "isModuleAccepted"));
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return false;
        }
        return !facet.isLibraryProject();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected ValidationInfo doValidate() {
        this.setOKActionEnabled(this.verifyInput());
        return null;
    }

    protected void doOKAction() {
        if (this.verifyInput()) {
            try {
                FetchAsGoogleTask task = FetchAsGoogleTask.createFetchAsGoogleTask(this.myProject, (Module)this.myModules.getSelectedItem(), this.myDeepLinkInputField.getText(), (SupportedLanguage.Language)this.myLanguageComboBox.getSelectedItem());
                UsageTracker.getInstance().trackEvent("appIndexing", "startFeagTask", null, null);
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)task);
                super.doOKAction();
            }
            catch (FetchAsGoogleClient.FetchAsGoogleException ex) {
                AppIndexingDialog.getLog().warn((Throwable)ex);
            }
        }
    }

    protected String getHelpId() {
        return "reference.dialogs.appindexing";
    }

    protected void doHelpAction() {
        try {
            Desktop.getDesktop().browse(new URI("http://g.co/appindexing"));
        }
        catch (Exception e) {
            e.printStackTrace();
            AppIndexingDialog.getLog().warn((Throwable)e);
        }
    }

    private boolean verifyInput() {
        this.myWarningLabel.setText("");
        this.myLoginButton.setVisible(false);
        this.myWarningPanel.setVisible(false);
        if (this.myModules.getSelectedItem() == null) {
            this.myWarningLabel.setText(MODULE_NOT_SPECIFIED_WARNING);
            this.myWarningPanel.setVisible(true);
            return false;
        }
        if (this.myDeepLinkInputField.getText().isEmpty()) {
            this.myWarningLabel.setText(DEEP_LINK_NOT_SPECIFIED_WARNING);
            this.myWarningPanel.setVisible(true);
            return false;
        }
        if (this.myLanguageComboBox.getSelectedItem() == null) {
            this.myWarningLabel.setText(LANGUAGE_NOT_SPECIFIED_WARNING);
            this.myWarningPanel.setVisible(true);
            return false;
        }
        if (!GoogleLogin.getInstance().isLoggedIn()) {
            this.myWarningLabel.setText(NO_LOGIN_WARNING);
            this.myLoginButton.setVisible(true);
            this.myLoginButton.setEnabled(true);
            this.myWarningPanel.setVisible(true);
            return false;
        }
        return true;
    }

    @NotNull
    private List<String> getDeepLinks() {
        XmlFile manifest;
        Module module;
        if (this.myProject.isInitialized() && (module = (Module)this.myModules.getSelectedItem()) != null && (manifest = ManifestUtils.getAndroidManifestPsi(module)) != null && manifest.getRootTag() != null) {
            List<String> list = DeepLinkUtils.getAllDeepLinks(manifest.getRootTag());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/AppIndexingDialog", "getDeepLinks"));
            }
            return list;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/ui/AppIndexingDialog", "getDeepLinks"));
        }
        return arrayList;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithHistory textFieldWithHistory;
        JButton jButton;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(550, 180));
        jPanel2.setMinimumSize(new Dimension(550, 180));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("URL:");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Language:");
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguageComboBox = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Module:");
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModulesComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, new Dimension(-1, 50), null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myWarningTitle = jLabel2 = new JLabel();
        jLabel2.setText("Warning:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoginButton = jButton = new JButton();
        ((Component)jButton).setVisible(false);
        jButton.setText("Sign in");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setVerifyInputWhenFocusTarget(false);
        jLabel6.setText("This test helps ensure that Google can find and open your URLs");
        jPanel4.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeepLinkInputField = textFieldWithHistory = new TextFieldWithHistory();
        jPanel2.add((Component)textFieldWithHistory, new GridConstraints(2, 1, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static class MyComboBoxEditor
    extends BasicComboBoxEditor {
        private static final String HINT_MESSAGE = "Specify the URL to test";

        MyComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            JBTextField editor = new JBTextField();
            editor.setBorder(null);
            editor.getEmptyText().setText(HINT_MESSAGE);
            return editor;
        }
    }
}

