/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.google.api.client.util.Maps;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadedApkManager {
    public static final UploadedApkManager INSTANCE = new UploadedApkManager();
    private final Map<BigInteger, ApkHolder> myUploadedApks = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hashApk(@NotNull File apkFile) {
        if (apkFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkFile", "com/google/appindexing/fetchasgoogle/UploadedApkManager", "hashApk"));
        }
        FilterInputStream dis = null;
        try {
            int bytesReaded;
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(new FileInputStream(apkFile), md);
            byte[] buffer = new byte[256];
            while ((bytesReaded = ((DigestInputStream)dis).read(buffer, 0, 256)) != -1) {
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private UploadedApkManager() {
    }

    @Nullable
    public synchronized ApkHolder getApkHolder(@NotNull byte[] apkHash) {
        if (apkHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkHash", "com/google/appindexing/fetchasgoogle/UploadedApkManager", "getApkHolder"));
        }
        return this.myUploadedApks.get(this.getKey(apkHash));
    }

    public synchronized void addUploadedApk(@NotNull byte[] apkHash, @NotNull ApkHolder apkHolder) {
        if (apkHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkHash", "com/google/appindexing/fetchasgoogle/UploadedApkManager", "addUploadedApk"));
        }
        if (apkHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apkHolder", "com/google/appindexing/fetchasgoogle/UploadedApkManager", "addUploadedApk"));
        }
        this.myUploadedApks.put(this.getKey(apkHash), apkHolder);
    }

    private BigInteger getKey(byte[] apkHash) {
        return new BigInteger(1, apkHash);
    }
}

