/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.editor;

import com.android.tools.idea.editors.AndroidFakeFileSystem;
import com.google.api.client.util.Lists;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.icons.AppIndexingIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppIndexingVirtualFile
extends LightVirtualFile {
    private static final String FILENAME_FORMAT = "GoogleAppIndexingTest [%s]";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss");
    private String myDeepLink;
    private List<Runnable> myContentChangingCallbacks;
    private FetchAsGoogleTask myFetchAsGoogleTask;

    public AppIndexingVirtualFile(@NotNull String deepLink, @NotNull FetchAsGoogleTask fetchAsGoogleTask) {
        if (deepLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepLink", "com/google/appindexing/editor/AppIndexingVirtualFile", "<init>"));
        }
        if (fetchAsGoogleTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchAsGoogleTask", "com/google/appindexing/editor/AppIndexingVirtualFile", "<init>"));
        }
        super(String.format(FILENAME_FORMAT, DATE_FORMAT.format(fetchAsGoogleTask.getCreatedTime())));
        this.myContentChangingCallbacks = Lists.newArrayList();
        this.myDeepLink = deepLink;
        this.myFetchAsGoogleTask = fetchAsGoogleTask;
    }

    public void fireContentChange() {
        for (Runnable callback : this.myContentChangingCallbacks) {
            callback.run();
        }
    }

    @NotNull
    public FetchAsGoogleTask getFetchAsGoogleTask() {
        FetchAsGoogleTask fetchAsGoogleTask = this.myFetchAsGoogleTask;
        if (fetchAsGoogleTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile", "getFetchAsGoogleTask"));
        }
        return fetchAsGoogleTask;
    }

    public void addContentChangeCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/google/appindexing/editor/AppIndexingVirtualFile", "addContentChangeCallback"));
        }
        this.myContentChangingCallbacks.add(runnable);
    }

    @NotNull
    public String getDeepLink() {
        String string = this.myDeepLink;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile", "getDeepLink"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public FileType getFileType() {
        AppIndexingFileType appIndexingFileType = AppIndexingFileType.INSTANCE;
        if (appIndexingFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile", "getFileType"));
        }
        return appIndexingFileType;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = AndroidFakeFileSystem.INSTANCE;
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myDeepLink;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile", "getPath"));
        }
        return string;
    }

    private static class AppIndexingFileType
    extends FakeFileType {
        public static final AppIndexingFileType INSTANCE = new AppIndexingFileType();

        private AppIndexingFileType() {
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/google/appindexing/editor/AppIndexingVirtualFile$AppIndexingFileType", "isMyFileType"));
            }
            return file.getFileType() instanceof AppIndexingFileType;
        }

        @NotNull
        public String getName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile$AppIndexingFileType", "getName"));
            }
            return "";
        }

        @NotNull
        public String getDescription() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/appindexing/editor/AppIndexingVirtualFile$AppIndexingFileType", "getDescription"));
            }
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return AppIndexingIcons.FETCH_AS_GOOGLE;
        }
    }
}

