/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.LibVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Task;

public class LibraryVariantData
extends BaseVariantData<LibVariantOutputData>
implements TestedVariantData {
    private final Map<VariantType, TestVariantData> testVariants = Maps.newEnumMap(VariantType.class);
    public ExtractAnnotations generateAnnotationsTask = null;

    public LibraryVariantData(AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration config, ErrorReporter errorReporter) {
        super(androidConfig, taskManager, config, errorReporter);
        this.createOutput(OutputFile.OutputType.MAIN, Collections.<FilterData>emptyList());
    }

    @Override
    protected LibVariantOutputData doCreateOutput(OutputFile.OutputType splitOutput, Collection<FilterData> filters) {
        return new LibVariantOutputData(splitOutput, filters, (BaseVariantData)this);
    }

    @Override
    public String getDescription() {
        if (this.getVariantConfiguration().hasFlavors()) {
            return String.format("%s build for flavor %s", this.getCapitalizedBuildTypeName(), this.getCapitalizedFlavorName());
        }
        return String.format("%s build", this.getCapitalizedBuildTypeName());
    }

    @Override
    public TestVariantData getTestVariantData(VariantType type) {
        return this.testVariants.get(type);
    }

    @Override
    public void setTestVariantData(TestVariantData testVariantData, VariantType type) {
        this.testVariants.put(type, testVariantData);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... generatedSourceFolders) {
        super.registerJavaGeneratingTask(task, generatedSourceFolders);
        if (this.generateAnnotationsTask != null) {
            for (File f : generatedSourceFolders) {
                this.generateAnnotationsTask.source(new Object[]{f});
            }
        }
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> generatedSourceFolders) {
        super.registerJavaGeneratingTask(task, generatedSourceFolders);
        if (this.generateAnnotationsTask != null) {
            for (File f : generatedSourceFolders) {
                this.generateAnnotationsTask.source(new Object[]{f});
            }
        }
    }
}

