/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.ide.common.res2.MergingException;
import com.android.utils.ILogger;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class LoggerWrapper
implements ILogger {
    private final Logger logger;
    private final LogLevel infoLogLevel;

    public static LoggerWrapper getLogger(Class<?> klass) {
        return new LoggerWrapper(Logging.getLogger(klass));
    }

    public LoggerWrapper(Logger logger) {
        this(logger, LogLevel.INFO);
    }

    public LoggerWrapper(Logger logger, LogLevel infoLogLevel) {
        this.logger = logger;
        this.infoLogLevel = infoLogLevel;
    }

    public void error(Throwable throwable, String s, Object ... objects) {
        if (throwable instanceof MergingException) {
            return;
        }
        if (!this.logger.isEnabled(LogLevel.ERROR)) {
            return;
        }
        if (objects != null && objects.length > 0) {
            s = String.format(s, objects);
        }
        if (throwable == null) {
            this.logger.log(LogLevel.ERROR, s);
        } else {
            this.logger.log(LogLevel.ERROR, s, throwable);
        }
    }

    public void warning(String s, Object ... objects) {
        if (!this.logger.isEnabled(LogLevel.WARN)) {
            return;
        }
        if (objects == null || objects.length == 0) {
            this.logger.log(LogLevel.WARN, s);
        } else {
            this.logger.log(LogLevel.WARN, String.format(s, objects));
        }
    }

    public void info(String s, Object ... objects) {
        if (!this.logger.isEnabled(this.infoLogLevel)) {
            return;
        }
        if (objects == null || objects.length == 0) {
            this.logger.log(this.infoLogLevel, s);
        } else {
            this.logger.log(this.infoLogLevel, String.format(s, objects));
        }
    }

    public void verbose(String s, Object ... objects) {
        if (!this.logger.isEnabled(LogLevel.DEBUG)) {
            return;
        }
        if (objects == null || objects.length == 0) {
            this.logger.log(LogLevel.DEBUG, s);
        } else {
            this.logger.log(LogLevel.DEBUG, String.format(s, objects));
        }
    }
}

