/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.ide.common.blame.SourcePosition;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.PositionXmlParser;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LintCliXmlParser
extends XmlParser {
    public Document parseXml(XmlContext context) {
        String xml = null;
        try {
            xml = context.getContents();
            if (xml != null) {
                return PositionXmlParser.parse((String)xml);
            }
        }
        catch (UnsupportedEncodingException e) {
            context.report(IssueRegistry.PARSER_ERROR, Location.create((File)context.file), e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage());
        }
        catch (SAXException e) {
            String message;
            Location location = Location.create((File)context.file);
            String string = message = e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage();
            if (message.startsWith("The processing instruction target matching \"[xX][mM][lL]\" is not allowed.")) {
                int prologue = xml.indexOf("<?xml ");
                int comment = xml.indexOf("<!--");
                if (prologue != -1 && comment != -1 && comment < prologue) {
                    message = "The XML prologue should appear before, not after, the first XML header/copyright comment. " + message;
                }
            }
            context.report(IssueRegistry.PARSER_ERROR, location, message);
        }
        catch (Throwable t) {
            context.log(t, null, new Object[0]);
        }
        return null;
    }

    public Location getLocation(XmlContext context, Node node) {
        return Location.create((File)context.file, (SourcePosition)PositionXmlParser.getPosition((Node)node));
    }

    public Location getLocation(XmlContext context, Node node, int start, int end) {
        return Location.create((File)context.file, (SourcePosition)PositionXmlParser.getPosition((Node)node, (int)start, (int)end));
    }

    public Location getNameLocation(XmlContext context, Node node) {
        Location location = this.getLocation(context, node);
        Position start = location.getStart();
        Position end = location.getEnd();
        if (start == null || end == null) {
            return location;
        }
        int delta = node instanceof Element ? 1 : 0;
        int length = node.getNodeName().length();
        int startOffset = start.getOffset() + delta;
        int startColumn = start.getColumn() + delta;
        return Location.create((File)location.getFile(), (Position)new DefaultPosition(start.getLine(), startColumn, startOffset), (Position)new DefaultPosition(end.getLine(), startColumn + length, startOffset + length));
    }

    public Location getValueLocation(XmlContext context, Attr node) {
        Location location = this.getLocation(context, node);
        Position start = location.getStart();
        Position end = location.getEnd();
        if (start == null || end == null) {
            return location;
        }
        int totalLength = end.getOffset() - start.getOffset();
        int length = node.getValue().length();
        int delta = totalLength - 1 - length;
        int startOffset = start.getOffset() + delta;
        int startColumn = start.getColumn() + delta;
        return Location.create((File)location.getFile(), (Position)new DefaultPosition(start.getLine(), startColumn, startOffset), (Position)new DefaultPosition(end.getLine(), startColumn + length, startOffset + length));
    }

    public Location.Handle createLocationHandle(XmlContext context, Node node) {
        return new LocationHandle(context.file, node);
    }

    public int getNodeStartOffset(XmlContext context, Node node) {
        return PositionXmlParser.getPosition((Node)node).getStartOffset();
    }

    public int getNodeEndOffset(XmlContext context, Node node) {
        return PositionXmlParser.getPosition((Node)node).getEndOffset();
    }

    private class LocationHandle
    implements Location.Handle {
        private final File mFile;
        private final Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        public Location resolve() {
            return Location.create((File)this.mFile, (SourcePosition)PositionXmlParser.getPosition((Node)this.mNode));
        }

        public void setClientData(Object clientData) {
            this.mClientData = clientData;
        }

        public Object getClientData() {
            return this.mClientData;
        }
    }
}

