/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.ecj.EcjTreeConverter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MagicLiteral;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EcjParser
extends JavaParser {
    private static final boolean DEBUG_DUMP_PARSE_ERRORS = false;
    private static final boolean KEEP_LOOKUP_ENVIRONMENT = !Boolean.getBoolean("lint.reset.ecj");
    private final LintClient mClient;
    private final Project mProject;
    private Map<File, ICompilationUnit> mSourceUnits;
    private Map<String, TypeDeclaration> mTypeUnits;
    private Parser mParser;
    protected EcjResult mEcjResult;
    private static final char[] PACKAGE_INFO_CHARS = new char[]{'p', 'a', 'c', 'k', 'a', 'g', 'e', '-', 'i', 'n', 'f', 'o'};

    public EcjParser(LintCliClient client, Project project) {
        this.mClient = client;
        this.mProject = project;
        this.mParser = this.getParser();
    }

    public static CompilerOptions createCompilerOptions() {
        long languageLevel;
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = languageLevel = 0x330000L;
        options.sourceLevel = languageLevel;
        options.targetJDK = languageLevel;
        options.originalComplianceLevel = languageLevel;
        options.originalSourceLevel = languageLevel;
        options.inlineJsrBytecode = true;
        options.parseLiteralExpressionsAsConstants = true;
        options.analyseResourceLeaks = false;
        options.docCommentSupport = false;
        options.defaultEncoding = "UTF-8";
        options.suppressOptionalErrors = true;
        options.generateClassFiles = false;
        options.isAnnotationBasedNullAnalysisEnabled = false;
        options.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        options.reportUnusedDeclaredThrownExceptionIncludeDocCommentReference = false;
        options.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
        options.reportUnusedParameterIncludeDocCommentReference = false;
        options.reportUnusedParameterWhenImplementingAbstract = false;
        options.reportUnusedParameterWhenOverridingConcrete = false;
        options.suppressWarnings = true;
        options.processAnnotations = true;
        options.storeAnnotations = true;
        options.verbose = false;
        return options;
    }

    public static long getLanguageLevel(int major, int minor) {
        assert (major == 1);
        switch (minor) {
            case 5: {
                return 0x310000L;
            }
            case 6: {
                return 0x320000L;
            }
        }
        return 0x330000L;
    }

    private Parser getParser() {
        if (this.mParser == null) {
            CompilerOptions options = EcjParser.createCompilerOptions();
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), options, (IProblemFactory)new DefaultProblemFactory());
            this.mParser = new Parser(problemReporter, options.parseLiteralExpressionsAsConstants);
            this.mParser.javadocParser.checkDocComment = false;
        }
        return this.mParser;
    }

    public void prepareJavaParse(List<JavaContext> contexts) {
        if (this.mProject == null || contexts.isEmpty()) {
            return;
        }
        ArrayList sources = Lists.newArrayListWithExpectedSize((int)contexts.size());
        this.mSourceUnits = Maps.newHashMapWithExpectedSize((int)sources.size());
        for (JavaContext context : contexts) {
            String contents = context.getContents();
            if (contents == null) continue;
            File file = context.file;
            CompilationUnit unit = new CompilationUnit(contents.toCharArray(), file.getPath(), "UTF-8");
            sources.add(unit);
            this.mSourceUnits.put(file, (ICompilationUnit)unit);
        }
        List<String> classPath = this.computeClassPath(contexts);
        try {
            this.mEcjResult = EcjParser.parse(EcjParser.createCompilerOptions(), sources, classPath, this.mClient);
        }
        catch (Throwable t) {
            this.mClient.log(t, "ECJ compiler crashed", new Object[0]);
        }
    }

    public static EcjResult parse(CompilerOptions options, List<ICompilationUnit> sourceUnits, List<String> classPath, LintClient client) {
        HashMap outputMap = Maps.newHashMapWithExpectedSize((int)sourceUnits.size());
        FileSystem environment = new FileSystem(classPath.toArray(new String[classPath.size()]), new String[0], options.defaultEncoding);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
            }
        };
        NonGeneratingCompiler compiler = new NonGeneratingCompiler((INameEnvironment)environment, policy, options, requestor, (IProblemFactory)problemFactory, outputMap);
        try {
            compiler.compile(sourceUnits.toArray(new ICompilationUnit[sourceUnits.size()]));
        }
        catch (OutOfMemoryError e) {
            environment.cleanup();
            compiler = null;
            environment = null;
            requestor = null;
            problemFactory = null;
            policy = null;
            String msg = "Ran out of memory analyzing .java sources with ECJ: Some lint checks may not be accurate (missing type information from the compiler)";
            if (client != null) {
                client.log(null, msg, new Object[0]);
            } else {
                System.out.println(msg);
            }
        }
        catch (Throwable t) {
            if (client != null) {
                CompilationUnitDeclaration currentUnit = compiler.getCurrentUnit();
                if (currentUnit == null || currentUnit.getFileName() == null) {
                    client.log(t, "ECJ compiler crashed", new Object[0]);
                } else {
                    client.log(t, "ECJ compiler crashed processing %1$s", new Object[]{new String(currentUnit.getFileName())});
                }
            } else {
                t.printStackTrace();
            }
            environment.cleanup();
            environment = null;
        }
        LookupEnvironment lookupEnvironment = compiler != null ? compiler.lookupEnvironment : null;
        return new EcjResult((INameEnvironment)environment, lookupEnvironment, outputMap);
    }

    private List<String> computeClassPath(List<JavaContext> contexts) {
        String androidJar;
        assert (this.mProject != null);
        ArrayList classPath = Lists.newArrayList();
        IAndroidTarget compileTarget = this.mProject.getBuildTarget();
        if (compileTarget != null && (androidJar = compileTarget.getPath(1)) != null && new File(androidJar).exists()) {
            classPath.add(androidJar);
        }
        HashSet libraries = Sets.newHashSet();
        HashSet names = Sets.newHashSet();
        for (File library : this.mProject.getJavaLibraries(true)) {
            libraries.add(library);
            names.add(EcjParser.getLibraryName(library));
        }
        for (Project project : this.mProject.getAllLibraries()) {
            for (File library : project.getJavaLibraries(true)) {
                String name = EcjParser.getLibraryName(library);
                if (names.contains(name)) continue;
                libraries.add(library);
                names.add(name);
            }
        }
        for (File file : libraries) {
            if (!file.exists()) continue;
            classPath.add(file.getPath());
        }
        EnumSet scope = contexts.get(0).getScope();
        if (!scope.contains(Scope.ALL_JAVA_FILES)) {
            for (File dir : this.mProject.getJavaClassFolders()) {
                if (!dir.exists()) continue;
                classPath.add(dir.getPath());
            }
        }
        return classPath;
    }

    private static String getLibraryName(File library) {
        String name = library.getName();
        if (name.equals("classes.jar")) {
            String path = library.getPath();
            int index = path.indexOf("exploded-aar");
            if (index != -1) {
                return path.substring(index);
            }
            index = path.indexOf("exploded-bundles");
            if (index != -1) {
                return path.substring(index);
            }
            File parent = library.getParentFile();
            if (parent != null) {
                return parent.getName() + File.separatorChar + name;
            }
        }
        return name;
    }

    public Node parseJava(JavaContext context) {
        String code = context.getContents();
        if (code == null) {
            return null;
        }
        CompilationUnitDeclaration unit = this.getParsedUnit(context, code);
        try {
            EcjTreeConverter converter = new EcjTreeConverter();
            converter.visit(code, (ASTNode)unit);
            List nodes = converter.getAll();
            if (nodes != null) {
                for (Node node : nodes) {
                    if (!(node instanceof lombok.ast.CompilationUnit)) continue;
                    return node;
                }
            }
            return null;
        }
        catch (Throwable t) {
            this.mClient.log(t, "Failed converting ECJ parse tree to Lombok for file %1$s", new Object[]{context.file.getPath()});
            return null;
        }
    }

    private CompilationUnitDeclaration getParsedUnit(JavaContext context, String code) {
        CompilationUnitDeclaration unit;
        ICompilationUnit sourceUnit = null;
        if (this.mSourceUnits != null && this.mEcjResult != null && (sourceUnit = this.mSourceUnits.get(context.file)) != null && (unit = this.mEcjResult.getCompilationUnit(sourceUnit)) != null) {
            return unit;
        }
        if (sourceUnit == null) {
            sourceUnit = new CompilationUnit(code.toCharArray(), context.file.getName(), "UTF-8");
        }
        try {
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
            return this.getParser().parse(sourceUnit, compilationResult);
        }
        catch (AbortCompilation e) {
            return null;
        }
    }

    public Location getLocation(JavaContext context, Node node) {
        Position position = node.getPosition();
        return Location.create((File)context.file, (String)context.getContents(), (int)position.getStart(), (int)position.getEnd());
    }

    public Location.Handle createLocationHandle(JavaContext context, Node node) {
        return new LocationHandle(context.file, node);
    }

    public void dispose(JavaContext context, Node compilationUnit) {
        ICompilationUnit sourceUnit;
        if (this.mSourceUnits != null && (sourceUnit = this.mSourceUnits.get(context.file)) != null) {
            CompilationUnitDeclaration unit;
            this.mSourceUnits.remove(context.file);
            if (this.mEcjResult != null && (unit = this.mEcjResult.getCompilationUnit(sourceUnit)) != null) {
                if (unit.types != null) {
                    for (TypeDeclaration type : unit.types) {
                        if (EcjParser.isAnnotationType(type)) {
                            return;
                        }
                        if (type.memberTypes == null) continue;
                        for (TypeDeclaration member : type.memberTypes) {
                            if (!EcjParser.isAnnotationType(member)) continue;
                            return;
                        }
                    }
                }
                this.mEcjResult.removeCompilationUnit(sourceUnit);
            }
        }
    }

    private static boolean isAnnotationType(TypeDeclaration type) {
        return TypeDeclaration.kind((int)type.modifiers) == 4;
    }

    public void dispose() {
        if (this.mEcjResult != null) {
            this.mEcjResult.dispose();
            this.mEcjResult = null;
        }
        this.mSourceUnits = null;
        this.mTypeUnits = null;
    }

    private static Object getNativeNode(Node node) {
        lombok.ast.TypeReference typeReference;
        VariableDeclaration declaration;
        VariableDefinition definition;
        Object nativeNode = node.getNativeNode();
        if (nativeNode != null) {
            return nativeNode;
        }
        Node parent = node.getParent();
        if (parent != null && (nativeNode = parent.getNativeNode()) != null) {
            return nativeNode;
        }
        if (node instanceof VariableDefinitionEntry) {
            node = node.getParent().getParent();
        }
        if (node instanceof VariableDeclaration && (definition = (declaration = (VariableDeclaration)node).astDefinition()) != null && (typeReference = definition.astTypeReference()) != null) {
            return typeReference.getNativeNode();
        }
        return null;
    }

    public JavaParser.ResolvedNode resolve(JavaContext context, Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof NameReference) {
            return this.resolve(((NameReference)nativeNode).binding);
        }
        if (nativeNode instanceof TypeReference) {
            return this.resolve((Binding)((TypeReference)nativeNode).resolvedType);
        }
        if (nativeNode instanceof MessageSend) {
            return this.resolve((Binding)((MessageSend)nativeNode).binding);
        }
        if (nativeNode instanceof AllocationExpression) {
            return this.resolve((Binding)((AllocationExpression)nativeNode).binding);
        }
        if (nativeNode instanceof TypeDeclaration) {
            return this.resolve((Binding)((TypeDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof ExplicitConstructorCall) {
            return this.resolve((Binding)((ExplicitConstructorCall)nativeNode).binding);
        }
        if (nativeNode instanceof Annotation) {
            AnnotationBinding compilerAnnotation = ((Annotation)nativeNode).getCompilerAnnotation();
            if (compilerAnnotation != null) {
                return new EcjResolvedAnnotation(compilerAnnotation);
            }
            return this.resolve((Binding)((Annotation)nativeNode).resolvedType);
        }
        if (nativeNode instanceof AbstractMethodDeclaration) {
            return this.resolve((Binding)((AbstractMethodDeclaration)nativeNode).binding);
        }
        if (nativeNode instanceof AbstractVariableDeclaration) {
            if (nativeNode instanceof LocalDeclaration) {
                return this.resolve((Binding)((LocalDeclaration)nativeNode).binding);
            }
            if (nativeNode instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)nativeNode;
                if (fieldDeclaration.initialization instanceof AllocationExpression) {
                    AllocationExpression allocation = (AllocationExpression)fieldDeclaration.initialization;
                    if (allocation.binding != null) {
                        return new EcjResolvedMethod(allocation.binding);
                    }
                }
                return this.resolve((Binding)fieldDeclaration.binding);
            }
        }
        return null;
    }

    private JavaParser.ResolvedNode resolve(Binding binding) {
        if (binding == null || binding instanceof ProblemBinding) {
            return null;
        }
        if (binding instanceof TypeBinding) {
            TypeBinding tb = (TypeBinding)binding;
            return new EcjResolvedClass(tb);
        }
        if (binding instanceof MethodBinding) {
            MethodBinding mb = (MethodBinding)binding;
            if (mb instanceof ProblemMethodBinding) {
                return null;
            }
            if (mb.declaringClass != null) {
                return new EcjResolvedMethod(mb);
            }
        } else if (binding instanceof LocalVariableBinding) {
            LocalVariableBinding lvb = (LocalVariableBinding)binding;
            if (lvb.type != null) {
                return new EcjResolvedVariable(lvb);
            }
        } else if (binding instanceof FieldBinding) {
            FieldBinding fb = (FieldBinding)binding;
            if (fb instanceof ProblemFieldBinding) {
                return null;
            }
            if (fb.type != null && fb.declaringClass != null) {
                return new EcjResolvedField(fb);
            }
        }
        return null;
    }

    private TypeDeclaration findAnnotationDeclaration(String signature) {
        if (this.mTypeUnits == null) {
            Collection<CompilationUnitDeclaration> units = this.mEcjResult.getCompilationUnits();
            this.mTypeUnits = Maps.newHashMapWithExpectedSize((int)units.size());
            for (CompilationUnitDeclaration unit : units) {
                if (unit.types == null) continue;
                for (TypeDeclaration typeDeclaration : unit.types) {
                    this.addTypeDeclaration(typeDeclaration);
                }
            }
        }
        return this.mTypeUnits.get(signature);
    }

    private void addTypeDeclaration(TypeDeclaration typeDeclaration) {
        String type = new String(typeDeclaration.binding.readableName());
        this.mTypeUnits.put(type, typeDeclaration);
        if (typeDeclaration.memberTypes != null) {
            for (TypeDeclaration member : typeDeclaration.memberTypes) {
                this.addTypeDeclaration(member);
            }
        }
    }

    public JavaParser.TypeDescriptor getType(JavaContext context, Node node) {
        Object nativeNode = EcjParser.getNativeNode(node);
        if (nativeNode == null) {
            return null;
        }
        if (nativeNode instanceof MessageSend) {
            nativeNode = ((MessageSend)nativeNode).binding;
        } else if (nativeNode instanceof AllocationExpression) {
            nativeNode = ((AllocationExpression)nativeNode).resolvedType;
        } else if (nativeNode instanceof NameReference) {
            nativeNode = ((NameReference)nativeNode).resolvedType;
        } else if (nativeNode instanceof Expression) {
            if (nativeNode instanceof Literal) {
                if (nativeNode instanceof StringLiteral) {
                    return EcjParser.getTypeDescriptor("java.lang.String");
                }
                if (nativeNode instanceof NumberLiteral) {
                    if (nativeNode instanceof IntLiteral) {
                        return EcjParser.getTypeDescriptor("int");
                    }
                    if (nativeNode instanceof LongLiteral) {
                        return EcjParser.getTypeDescriptor("long");
                    }
                    if (nativeNode instanceof CharLiteral) {
                        return EcjParser.getTypeDescriptor("char");
                    }
                    if (nativeNode instanceof FloatLiteral) {
                        return EcjParser.getTypeDescriptor("float");
                    }
                    if (nativeNode instanceof DoubleLiteral) {
                        return EcjParser.getTypeDescriptor("double");
                    }
                } else if (nativeNode instanceof MagicLiteral) {
                    if (nativeNode instanceof TrueLiteral || nativeNode instanceof FalseLiteral) {
                        return EcjParser.getTypeDescriptor("boolean");
                    }
                    if (nativeNode instanceof NullLiteral) {
                        return EcjParser.getTypeDescriptor("null");
                    }
                }
            }
            nativeNode = ((Expression)nativeNode).resolvedType;
        } else if (nativeNode instanceof TypeDeclaration) {
            nativeNode = ((TypeDeclaration)nativeNode).binding;
        } else if (nativeNode instanceof AbstractMethodDeclaration) {
            nativeNode = ((AbstractMethodDeclaration)nativeNode).binding;
        }
        if (nativeNode instanceof Binding) {
            Binding binding = (Binding)nativeNode;
            if (binding instanceof TypeBinding) {
                TypeBinding tb = (TypeBinding)binding;
                return this.getTypeDescriptor(tb);
            }
            if (binding instanceof LocalVariableBinding) {
                LocalVariableBinding lvb = (LocalVariableBinding)binding;
                if (lvb.type != null) {
                    return this.getTypeDescriptor(lvb.type);
                }
            } else if (binding instanceof FieldBinding) {
                FieldBinding fb = (FieldBinding)binding;
                if (fb.type != null) {
                    return this.getTypeDescriptor(fb.type);
                }
            } else {
                if (binding instanceof MethodBinding) {
                    return this.getTypeDescriptor(((MethodBinding)binding).returnType);
                }
                if (binding instanceof ProblemBinding) {
                    return null;
                }
            }
        }
        return null;
    }

    public JavaParser.ResolvedClass findClass(JavaContext context, String fullyQualifiedName) {
        ReferenceBinding type;
        String internal = ClassContext.getInternalName((String)fullyQualifiedName);
        ArrayList arrays = Lists.newArrayList();
        for (String segment : Splitter.on((char)'/').split((CharSequence)internal)) {
            arrays.add(segment.toCharArray());
        }
        char[][] compoundName = new char[arrays.size()][];
        int n = arrays.size();
        for (int i = 0; i < n; ++i) {
            compoundName[i] = (char[])arrays.get(i);
        }
        LookupEnvironment lookup = this.mEcjResult.mLookupEnvironment;
        if (lookup != null && (type = lookup.getType((char[][])compoundName)) != null && !(type instanceof ProblemReferenceBinding)) {
            return new EcjResolvedClass((TypeBinding)type);
        }
        return null;
    }

    private JavaParser.TypeDescriptor getTypeDescriptor(TypeBinding resolvedType) {
        if (resolvedType == null) {
            return null;
        }
        return new EcjTypeDescriptor(resolvedType);
    }

    private static JavaParser.TypeDescriptor getTypeDescriptor(String fqn) {
        return new JavaParser.DefaultTypeDescriptor(fqn);
    }

    private static MethodBinding findSuperMethodBinding(MethodBinding binding) {
        try {
            for (ReferenceBinding superclass = binding.declaringClass.superclass(); superclass != null; superclass = superclass.superclass()) {
                MethodBinding[] methods;
                for (MethodBinding method : methods = superclass.getMethods(binding.selector, binding.parameters.length)) {
                    if (!method.areParameterErasuresEqual(binding)) continue;
                    return method;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Collection<JavaParser.ResolvedAnnotation> merge(Collection<JavaParser.ResolvedAnnotation> first, Collection<JavaParser.ResolvedAnnotation> second) {
        if (first == null || first.isEmpty()) {
            if (second == null) {
                return Collections.emptyList();
            }
            return second;
        }
        if (second == null || second.isEmpty()) {
            return first;
        }
        int size = first.size() + second.size();
        ArrayList merged = Lists.newArrayListWithExpectedSize((int)size);
        merged.addAll(first);
        merged.addAll(second);
        return merged;
    }

    static List<JavaParser.ResolvedAnnotation> ensureUnique(List<JavaParser.ResolvedAnnotation> list) {
        if (list.size() < 2) {
            return list;
        }
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            JavaParser.ResolvedAnnotation current = list.get(i);
            String currentName = current.getName();
            for (int j = n - 1; j > i; --j) {
                JavaParser.ResolvedAnnotation later = list.get(j);
                String laterName = later.getName();
                if (!currentName.equals(laterName)) continue;
                list.remove(j);
                --n;
            }
        }
        return list;
    }

    private Object getConstantValue(Object value) {
        if (value instanceof Constant) {
            if (value == Constant.NotAConstant) {
                return null;
            }
            if (value instanceof StringConstant) {
                return ((StringConstant)value).stringValue();
            }
            if (value instanceof IntConstant) {
                return ((IntConstant)value).intValue();
            }
            if (value instanceof BooleanConstant) {
                return ((BooleanConstant)value).booleanValue();
            }
            if (value instanceof FloatConstant) {
                return Float.valueOf(((FloatConstant)value).floatValue());
            }
            if (value instanceof LongConstant) {
                return ((LongConstant)value).longValue();
            }
            if (value instanceof DoubleConstant) {
                return ((DoubleConstant)value).doubleValue();
            }
            if (value instanceof ShortConstant) {
                return ((ShortConstant)value).shortValue();
            }
            if (value instanceof CharConstant) {
                return Character.valueOf(((CharConstant)value).charValue());
            }
            if (value instanceof ByteConstant) {
                return ((ByteConstant)value).byteValue();
            }
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            if (array.length > 0) {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)array.length);
                for (Object element : array) {
                    list.add(this.getConstantValue(element));
                }
                if (!list.isEmpty()) {
                    Object first = list.get(0);
                    if (first instanceof String) {
                        return list.toArray(new String[list.size()]);
                    }
                    if (first instanceof java.lang.annotation.Annotation) {
                        return list.toArray(new Annotation[list.size()]);
                    }
                    if (first instanceof Class) {
                        return list.toArray(new Class[list.size()]);
                    }
                }
                return list.toArray();
            }
        } else {
            if (value instanceof AnnotationBinding) {
                return new EcjResolvedAnnotation((AnnotationBinding)value);
            }
            if (value instanceof FieldBinding) {
                return new EcjResolvedField((FieldBinding)value);
            }
        }
        return value;
    }

    private static boolean sameChars(String str, char[] chars) {
        int length = str.length();
        if (chars.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (chars[i] == str.charAt(i)) continue;
            return false;
        }
        return true;
    }

    static boolean startsWithCompound(String name, char[][] compoundName) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        int n = compoundName.length;
        for (int i = 0; i < n; ++i) {
            char[] o = compoundName[i];
            int m = o.length;
            for (int j = 0; j < m; ++j) {
                if (index == length) {
                    return false;
                }
                if (name.charAt(index) != o[j] && (o[j] != '$' || name.charAt(index) != '.')) {
                    return false;
                }
                ++index;
            }
            if (i >= n - 1) continue;
            if (index == length) {
                return true;
            }
            if (name.charAt(index) != '.') {
                return false;
            }
            if (++index != length) continue;
            return true;
        }
        return index == length;
    }

    static boolean equalsCompound(String name, char[][] compoundName) {
        int length = name.length();
        if (length == 0) {
            return false;
        }
        int index = 0;
        int n = compoundName.length;
        for (int i = 0; i < n; ++i) {
            char[] o = compoundName[i];
            int m = o.length;
            for (int j = 0; j < m; ++j) {
                if (index == length) {
                    return false;
                }
                if (name.charAt(index) != o[j] && (o[j] != '$' || name.charAt(index) != '.')) {
                    return false;
                }
                ++index;
            }
            if (i >= n - 1) continue;
            if (index == length) {
                return false;
            }
            if (name.charAt(index) != '.') {
                return false;
            }
            if (++index != length) continue;
            return false;
        }
        return index == length;
    }

    private static boolean isInheritor(ReferenceBinding cls, String name) {
        while (cls != null) {
            ReferenceBinding[] interfaces;
            for (ReferenceBinding binding : interfaces = cls.superInterfaces()) {
                if (!EcjParser.isInheritor(binding, name)) continue;
                return true;
            }
            if (EcjParser.equalsCompound(name, cls.compoundName)) {
                return true;
            }
            cls = cls.superclass();
        }
        return false;
    }

    private class EcjResolvedAnnotation
    extends JavaParser.ResolvedAnnotation {
        private final AnnotationBinding mBinding;
        private final String mName;

        private EcjResolvedAnnotation(AnnotationBinding binding) {
            this.mBinding = binding;
            this.mName = new String(this.mBinding.getAnnotationType().readableName());
        }

        public String getName() {
            return this.mName;
        }

        public boolean matches(String name) {
            return name.equals(this.mName);
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor((TypeBinding)this.mBinding.getAnnotationType());
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public JavaParser.ResolvedClass getClassType() {
            ReferenceBinding annotationType = this.mBinding.getAnnotationType();
            return new EcjResolvedClass((TypeBinding)annotationType){

                @Override
                public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
                    AnnotationBinding[] annotations = this.mBinding.getAnnotations();
                    int count = annotations.length;
                    if (count > 0) {
                        ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                        for (AnnotationBinding annotation : annotations) {
                            if (annotation == null) continue;
                            char[] readableName = annotation.getAnnotationType().readableName();
                            if (EcjParser.sameChars("android.support.annotation.IntDef", readableName) || EcjParser.sameChars("android.support.annotation.StringDef", readableName)) {
                                TypeDeclaration typeDeclaration = EcjParser.this.findAnnotationDeclaration(this.getName());
                                if (typeDeclaration == null || typeDeclaration.annotations == null) continue;
                                Annotation astAnnotation = null;
                                for (Annotation a : typeDeclaration.annotations) {
                                    if (a.resolvedType == null || !EcjParser.sameChars("android.support.annotation.IntDef", a.resolvedType.readableName()) && !EcjParser.sameChars("android.support.annotation.StringDef", a.resolvedType.readableName())) continue;
                                    astAnnotation = a;
                                    break;
                                }
                                if (astAnnotation != null) {
                                    result.add(new EcjAstAnnotation(annotation, astAnnotation));
                                    continue;
                                }
                            }
                            result.add(new EcjResolvedAnnotation(annotation));
                        }
                        return result;
                    }
                    return Collections.emptyList();
                }
            };
        }

        public List<JavaParser.ResolvedAnnotation.Value> getValues() {
            ElementValuePair[] pairs = this.mBinding.getElementValuePairs();
            if (pairs != null && pairs.length > 0) {
                ArrayList values = Lists.newArrayListWithExpectedSize((int)pairs.length);
                for (ElementValuePair pair : pairs) {
                    values.add(new JavaParser.ResolvedAnnotation.Value(new String(pair.getName()), this.getPairValue(pair)));
                }
            }
            return Collections.emptyList();
        }

        public Object getValue(String name) {
            ElementValuePair[] pairs = this.mBinding.getElementValuePairs();
            if (pairs != null) {
                for (ElementValuePair pair : pairs) {
                    if (!EcjParser.sameChars(name, pair.getName())) continue;
                    return this.getPairValue(pair);
                }
            }
            return null;
        }

        private Object getPairValue(ElementValuePair pair) {
            return EcjParser.this.getConstantValue(pair.getValue());
        }

        public String getSignature() {
            return this.mName;
        }

        public int getModifiers() {
            return 0;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ArrayList compiled = null;
            AnnotationBinding[] annotations = this.mBinding.getAnnotationType().getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                compiled = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    compiled.add(new EcjResolvedAnnotation(annotation));
                }
            }
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.mClient);
            Collection<JavaParser.ResolvedAnnotation> external = manager.getAnnotations(this);
            return EcjParser.merge(compiled, external);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedAnnotation that = (EcjResolvedAnnotation)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals((Object)that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }

        private class EcjAstAnnotation
        extends EcjResolvedAnnotation {
            private final Annotation mAstAnnotation;
            private List<JavaParser.ResolvedAnnotation.Value> mValues;

            public EcjAstAnnotation(AnnotationBinding binding, Annotation astAnnotation) {
                super(binding);
                this.mAstAnnotation = astAnnotation;
            }

            @Override
            public List<JavaParser.ResolvedAnnotation.Value> getValues() {
                if (this.mValues == null) {
                    MemberValuePair[] memberValuePairs = this.mAstAnnotation.memberValuePairs();
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)memberValuePairs.length);
                    for (MemberValuePair pair : memberValuePairs) {
                        Expression expression = pair.value;
                        Object[] value = null;
                        if (expression instanceof ArrayInitializer) {
                            ArrayInitializer initializer = (ArrayInitializer)expression;
                            Expression[] expressions = initializer.expressions;
                            ArrayList values = Lists.newArrayList();
                            for (Expression e : expressions) {
                                if (e instanceof NameReference) {
                                    JavaParser.ResolvedNode resolved = EcjParser.this.resolve(((NameReference)e).binding);
                                    if (resolved == null) continue;
                                    values.add(resolved);
                                    continue;
                                }
                                if (e instanceof IntLiteral) {
                                    values.add(((IntLiteral)e).value);
                                    continue;
                                }
                                if (e instanceof StringLiteral) {
                                    values.add(String.valueOf(((StringLiteral)e).source()));
                                    continue;
                                }
                                values.add(e.toString());
                            }
                            value = values.toArray();
                        } else if (expression instanceof IntLiteral) {
                            IntLiteral intLiteral = (IntLiteral)expression;
                            value = intLiteral.value;
                        } else if (expression instanceof TrueLiteral) {
                            value = true;
                        } else if (expression instanceof FalseLiteral) {
                            value = false;
                        } else if (expression instanceof StringLiteral) {
                            value = String.valueOf(((StringLiteral)expression).source());
                        }
                        result.add(new JavaParser.ResolvedAnnotation.Value(new String(pair.name), (Object)value));
                    }
                    this.mValues = result;
                }
                return this.mValues;
            }

            @Override
            public Object getValue(String name) {
                for (JavaParser.ResolvedAnnotation.Value value : this.getValues()) {
                    if (!name.equals(value.name)) continue;
                    return value.value;
                }
                return null;
            }
        }
    }

    private class EcjResolvedVariable
    extends JavaParser.ResolvedVariable {
        private LocalVariableBinding mBinding;

        private EcjResolvedVariable(LocalVariableBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matches(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public int getModifiers() {
            return this.mBinding.modifiers;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    result.add(new EcjResolvedAnnotation(annotation));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedVariable that = (EcjResolvedVariable)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedField
    extends JavaParser.ResolvedField {
        private FieldBinding mBinding;

        private EcjResolvedField(FieldBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matches(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public JavaParser.TypeDescriptor getType() {
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(this.mBinding.type);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass((TypeBinding)this.mBinding.declaringClass);
        }

        public Object getValue() {
            return EcjParser.this.getConstantValue(this.mBinding.constant());
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ArrayList compiled = null;
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count > 0) {
                compiled = Lists.newArrayListWithExpectedSize((int)count);
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    compiled.add(new EcjResolvedAnnotation(annotation));
                }
            }
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.mClient);
            Collection<JavaParser.ResolvedAnnotation> external = manager.getAnnotations(this);
            return EcjParser.merge(compiled, external);
        }

        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean isInPackage(String pkgName, boolean includeSubPackages) {
            PackageBinding pkg = this.mBinding.declaringClass.getPackage();
            if (pkg != null) {
                return includeSubPackages ? EcjParser.startsWithCompound(pkgName, pkg.compoundName) : EcjParser.equalsCompound(pkgName, pkg.compoundName);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedField that = (EcjResolvedField)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedPackage
    extends JavaParser.ResolvedPackage {
        private final PackageBinding mBinding;

        public EcjResolvedPackage(PackageBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public String getSignature() {
            return this.getName();
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            ExternalAnnotationRepository manager;
            Collection<JavaParser.ResolvedAnnotation> external;
            List<Object> all = Lists.newArrayListWithExpectedSize((int)2);
            AnnotationBinding[] annotations = this.mBinding.getAnnotations();
            int count = annotations.length;
            if (count == 0) {
                Binding pkgInfo = this.mBinding.getTypeOrPackage(PACKAGE_INFO_CHARS);
                if (pkgInfo != null) {
                    annotations = pkgInfo.getAnnotations();
                }
                count = annotations.length;
            }
            if (count > 0) {
                for (AnnotationBinding annotation : annotations) {
                    if (annotation == null) continue;
                    all.add((Object)new EcjResolvedAnnotation(annotation));
                }
            }
            if ((external = (manager = ExternalAnnotationRepository.get(EcjParser.this.mClient)).getAnnotations(this)) != null) {
                all.addAll(external);
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public JavaParser.ResolvedPackage getParentPackage() {
            char[][] compoundName = this.mBinding.compoundName;
            if (compoundName.length == 1) {
                return null;
            }
            PackageBinding defaultPackage = this.mBinding.environment.defaultPackage;
            PackageBinding packageBinding = (PackageBinding)defaultPackage.getTypeOrPackage(compoundName[0]);
            if (packageBinding == null || packageBinding instanceof ProblemPackageBinding) {
                return null;
            }
            int packageLength = compoundName.length - 1;
            for (int i = 1; i < packageLength; ++i) {
                Binding next = packageBinding.getTypeOrPackage(compoundName[i]);
                if (next == null) {
                    return null;
                }
                if (!(next instanceof PackageBinding)) continue;
                if (next instanceof ProblemPackageBinding) {
                    return null;
                }
                packageBinding = (PackageBinding)next;
            }
            return new EcjResolvedPackage(packageBinding);
        }

        public int getModifiers() {
            return 0;
        }
    }

    private class EcjResolvedClass
    extends JavaParser.ResolvedClass {
        protected final TypeBinding mBinding;

        private EcjResolvedClass(TypeBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            String name = new String(this.mBinding.readableName());
            if (name.indexOf(46) == -1 && this.mBinding.enclosingType() != null) {
                return new String(this.mBinding.enclosingType().readableName()) + '.' + name;
            }
            return name;
        }

        public String getSimpleName() {
            return new String(this.mBinding.shortReadableName());
        }

        public boolean matches(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public JavaParser.ResolvedClass getSuperClass() {
            ReferenceBinding refBinding;
            ReferenceBinding superClass;
            if (this.mBinding instanceof ReferenceBinding && (superClass = (refBinding = (ReferenceBinding)this.mBinding).superclass()) != null) {
                return new EcjResolvedClass((TypeBinding)superClass);
            }
            return null;
        }

        public JavaParser.ResolvedClass getContainingClass() {
            if (this.mBinding instanceof NestedTypeBinding) {
                NestedTypeBinding ntb = (NestedTypeBinding)this.mBinding;
                if (ntb.enclosingType != null) {
                    return new EcjResolvedClass((TypeBinding)ntb.enclosingType);
                }
            }
            return null;
        }

        public boolean isSubclassOf(String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                while (cls != null) {
                    if (EcjParser.equalsCompound(name, cls.compoundName)) {
                        return true;
                    }
                    cls = cls.superclass();
                }
            }
            return false;
        }

        public boolean isImplementing(String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                return EcjParser.isInheritor(cls, name);
            }
            return false;
        }

        public boolean isInheritingFrom(String name, boolean strict) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                if (strict) {
                    cls = cls.superclass();
                }
                return EcjParser.isInheritor(cls, name);
            }
            return false;
        }

        public Iterable<JavaParser.ResolvedMethod> getConstructors() {
            ReferenceBinding cls;
            MethodBinding[] methods;
            if (this.mBinding instanceof ReferenceBinding && (methods = (cls = (ReferenceBinding)this.mBinding).getMethods(TypeConstants.INIT)) != null) {
                int count = methods.length;
                ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                for (MethodBinding method : methods) {
                    if (!method.isConstructor()) continue;
                    result.add(new EcjResolvedMethod(method));
                }
                return result;
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedMethod> getMethods(String name, boolean includeInherited) {
            return this.findMethods(name, includeInherited);
        }

        public Iterable<JavaParser.ResolvedMethod> getMethods(boolean includeInherited) {
            return this.findMethods(null, includeInherited);
        }

        private Iterable<JavaParser.ResolvedMethod> findMethods(String name, boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                MethodBinding[] methods;
                ReferenceBinding cls;
                if (includeInherited) {
                    ArrayList result = null;
                    for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                        int count;
                        MethodBinding[] methods2;
                        MethodBinding[] methodBindingArray = methods2 = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                        if (methods2 == null || (count = methods2.length) <= 0) continue;
                        if (result == null) {
                            result = Lists.newArrayListWithExpectedSize((int)count);
                        }
                        for (MethodBinding method : methods2) {
                            if (method.isConstructor()) continue;
                            boolean masked = false;
                            for (JavaParser.ResolvedMethod m : result) {
                                MethodBinding mb = ((EcjResolvedMethod)m).mBinding;
                                if (!mb.areParameterErasuresEqual(method)) continue;
                                masked = true;
                                break;
                            }
                            if (masked) continue;
                            result.add(new EcjResolvedMethod(method));
                        }
                    }
                    return result != null ? result : Collections.emptyList();
                }
                MethodBinding[] methodBindingArray = methods = name != null ? cls.getMethods(name.toCharArray()) : cls.methods();
                if (methods != null) {
                    int count = methods.length;
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                    for (MethodBinding method : methods) {
                        if (method.isConstructor()) continue;
                        result.add(new EcjResolvedMethod(method));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            List<Object> all = Lists.newArrayListWithExpectedSize((int)2);
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.mClient);
            if (this.mBinding instanceof ReferenceBinding) {
                for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    Collection<JavaParser.ResolvedAnnotation> external;
                    AnnotationBinding[] annotations = cls.getAnnotations();
                    int count = annotations.length;
                    if (count > 0) {
                        all = Lists.newArrayListWithExpectedSize((int)count);
                        for (AnnotationBinding annotation : annotations) {
                            if (annotation == null) continue;
                            all.add((Object)new EcjResolvedAnnotation(annotation));
                        }
                    }
                    if ((external = manager.getAnnotations(new EcjResolvedClass((TypeBinding)cls))) == null) continue;
                    all.addAll(external);
                }
            } else {
                Collection<JavaParser.ResolvedAnnotation> external = manager.getAnnotations(this);
                if (external != null) {
                    all.addAll(external);
                }
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public Iterable<JavaParser.ResolvedField> getFields(boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls;
                if (includeInherited) {
                    ArrayList result = null;
                    for (cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                        int count;
                        FieldBinding[] fields = cls.fields();
                        if (fields == null || (count = fields.length) <= 0) continue;
                        if (result == null) {
                            result = Lists.newArrayListWithExpectedSize((int)count);
                        }
                        for (FieldBinding field : fields) {
                            boolean masked = false;
                            for (JavaParser.ResolvedField f : result) {
                                FieldBinding mb = ((EcjResolvedField)f).mBinding;
                                if (!Arrays.equals(mb.readableName(), field.readableName())) continue;
                                masked = true;
                                break;
                            }
                            if (masked) continue;
                            result.add(new EcjResolvedField(field));
                        }
                    }
                    return result != null ? result : Collections.emptyList();
                }
                FieldBinding[] fields = cls.fields();
                if (fields != null) {
                    int count = fields.length;
                    ArrayList result = Lists.newArrayListWithExpectedSize((int)count);
                    for (FieldBinding field : fields) {
                        result.add(new EcjResolvedField(field));
                    }
                    return result;
                }
            }
            return Collections.emptyList();
        }

        public JavaParser.ResolvedField getField(String name, boolean includeInherited) {
            if (this.mBinding instanceof ReferenceBinding) {
                for (ReferenceBinding cls = (ReferenceBinding)this.mBinding; cls != null; cls = cls.superclass()) {
                    FieldBinding[] fields = cls.fields();
                    if (fields != null) {
                        for (FieldBinding field : fields) {
                            if (!EcjParser.sameChars(name, field.name)) continue;
                            return new EcjResolvedField(field);
                        }
                    }
                    if (!includeInherited) break;
                }
            }
            return null;
        }

        public JavaParser.ResolvedPackage getPackage() {
            return new EcjResolvedPackage(this.mBinding.getPackage());
        }

        public int getModifiers() {
            if (this.mBinding instanceof ReferenceBinding) {
                ReferenceBinding cls = (ReferenceBinding)this.mBinding;
                return cls.getAccessFlags();
            }
            return 0;
        }

        public String getSignature() {
            return this.getName();
        }

        public boolean isInPackage(String pkgName, boolean includeSubPackages) {
            PackageBinding pkg = this.mBinding.getPackage();
            if (pkg != null) {
                return includeSubPackages ? EcjParser.startsWithCompound(pkgName, pkg.compoundName) : EcjParser.equalsCompound(pkgName, pkg.compoundName);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedClass that = (EcjResolvedClass)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjResolvedMethod
    extends JavaParser.ResolvedMethod {
        private MethodBinding mBinding;

        private EcjResolvedMethod(MethodBinding binding) {
            this.mBinding = binding;
            assert (this.mBinding.declaringClass != null);
        }

        public String getName() {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return new String(c);
        }

        public boolean matches(String name) {
            char[] c = this.isConstructor() ? this.mBinding.declaringClass.readableName() : this.mBinding.selector;
            return EcjParser.sameChars(name, c);
        }

        public JavaParser.ResolvedClass getContainingClass() {
            return new EcjResolvedClass((TypeBinding)this.mBinding.declaringClass);
        }

        public int getArgumentCount() {
            return this.mBinding.parameters != null ? this.mBinding.parameters.length : 0;
        }

        public JavaParser.TypeDescriptor getArgumentType(int index) {
            TypeBinding parameterType = this.mBinding.parameters[index];
            JavaParser.TypeDescriptor typeDescriptor = EcjParser.this.getTypeDescriptor(parameterType);
            assert (typeDescriptor != null);
            return typeDescriptor;
        }

        public boolean argumentMatchesType(int index, String signature) {
            return EcjParser.sameChars(signature, this.mBinding.parameters[index].readableName());
        }

        public JavaParser.TypeDescriptor getReturnType() {
            return this.isConstructor() ? null : EcjParser.this.getTypeDescriptor(this.mBinding.returnType);
        }

        public boolean isConstructor() {
            return this.mBinding.isConstructor();
        }

        public JavaParser.ResolvedMethod getSuperMethod() {
            MethodBinding superBinding = EcjParser.findSuperMethodBinding(this.mBinding);
            if (superBinding != null) {
                return new EcjResolvedMethod(superBinding);
            }
            return null;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            List<Object> all = Lists.newArrayListWithExpectedSize((int)4);
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.mClient);
            MethodBinding binding = this.mBinding;
            while (binding != null) {
                Collection<JavaParser.ResolvedAnnotation> external;
                AnnotationBinding[] annotations = binding.getAnnotations();
                int count = annotations.length;
                if (count > 0) {
                    for (AnnotationBinding annotation : annotations) {
                        if (annotation == null) continue;
                        all.add((Object)new EcjResolvedAnnotation(annotation));
                    }
                }
                if ((external = manager.getAnnotations(new EcjResolvedMethod(binding))) != null) {
                    all.addAll(external);
                }
                binding = EcjParser.findSuperMethodBinding(binding);
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getParameterAnnotations(int index) {
            List<Object> all = Lists.newArrayListWithExpectedSize((int)4);
            ExternalAnnotationRepository manager = ExternalAnnotationRepository.get(EcjParser.this.mClient);
            MethodBinding binding = this.mBinding;
            while (binding != null) {
                Collection<JavaParser.ResolvedAnnotation> external;
                AnnotationBinding[] annotations;
                int count;
                AnnotationBinding[][] parameterAnnotations = binding.getParameterAnnotations();
                if (parameterAnnotations != null && index >= 0 && index < parameterAnnotations.length && (count = (annotations = parameterAnnotations[index]).length) > 0) {
                    for (AnnotationBinding annotation : annotations) {
                        if (annotation == null) continue;
                        all.add((Object)new EcjResolvedAnnotation(annotation));
                    }
                }
                if ((external = manager.getAnnotations(new EcjResolvedMethod(binding), index)) != null) {
                    all.addAll(external);
                }
                binding = EcjParser.findSuperMethodBinding(binding);
            }
            all = EcjParser.ensureUnique((List<JavaParser.ResolvedAnnotation>)all);
            return all;
        }

        public int getModifiers() {
            return this.mBinding.getAccessFlags();
        }

        public String getSignature() {
            return this.mBinding.toString();
        }

        public boolean isInPackage(String pkgName, boolean includeSubPackages) {
            PackageBinding pkg = this.mBinding.declaringClass.getPackage();
            if (pkg != null) {
                return includeSubPackages ? EcjParser.startsWithCompound(pkgName, pkg.compoundName) : EcjParser.equalsCompound(pkgName, pkg.compoundName);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjResolvedMethod that = (EcjResolvedMethod)((Object)o);
            return !(this.mBinding != null ? !this.mBinding.equals(that.mBinding) : that.mBinding != null);
        }

        public int hashCode() {
            return this.mBinding != null ? this.mBinding.hashCode() : 0;
        }
    }

    private class EcjTypeDescriptor
    extends JavaParser.TypeDescriptor {
        private final TypeBinding mBinding;

        private EcjTypeDescriptor(TypeBinding binding) {
            this.mBinding = binding;
        }

        public String getName() {
            return new String(this.mBinding.readableName());
        }

        public boolean matchesName(String name) {
            return EcjParser.sameChars(name, this.mBinding.readableName());
        }

        public boolean matchesSignature(String signature) {
            return EcjParser.sameChars(signature, this.mBinding.readableName());
        }

        public boolean isPrimitive() {
            return this.mBinding.isPrimitiveType();
        }

        public boolean isArray() {
            return this.mBinding.isArrayType();
        }

        public String getSignature() {
            return this.getName();
        }

        public JavaParser.ResolvedClass getTypeClass() {
            if (!this.mBinding.isPrimitiveType()) {
                return new EcjResolvedClass(this.mBinding);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            EcjTypeDescriptor that = (EcjTypeDescriptor)((Object)o);
            return this.mBinding.equals(that.mBinding);
        }

        public int hashCode() {
            return this.mBinding.hashCode();
        }
    }

    private static class NonGeneratingCompiler
    extends Compiler {
        private Map<ICompilationUnit, CompilationUnitDeclaration> mUnits;
        private CompilationUnitDeclaration mCurrentUnit;

        public NonGeneratingCompiler(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions options, ICompilerRequestor requestor, IProblemFactory problemFactory, Map<ICompilationUnit, CompilationUnitDeclaration> units) {
            super(environment, policy, options, requestor, problemFactory, null, null);
            this.mUnits = units;
        }

        CompilationUnitDeclaration getCurrentUnit() {
            return this.mCurrentUnit;
        }

        protected synchronized void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
            super.addCompilationUnit(sourceUnit, parsedUnit);
            this.mUnits.put(sourceUnit, parsedUnit);
        }

        public void process(CompilationUnitDeclaration unit, int unitNumber) {
            this.mCurrentUnit = this.lookupEnvironment.unitBeingCompleted = unit;
            this.parser.getMethodBodies(unit);
            if (unit.scope != null) {
                unit.scope.faultInTypes();
                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
            }
            unit.resolve();
            unit.analyseCode();
            if (this.options.produceReferenceInfo && unit.scope != null) {
                unit.scope.storeDependencyInfo();
            }
            unit.finalizeProblems();
            unit.compilationResult.totalUnitsKnown = this.totalUnits;
            this.lookupEnvironment.unitBeingCompleted = null;
        }

        public void reset() {
            if (KEEP_LOOKUP_ENVIRONMENT) {
                this.parser.scanner.source = null;
                this.unitsToProcess = null;
                if (DebugRequestor != null) {
                    DebugRequestor.reset();
                }
                this.problemReporter.reset();
            } else {
                super.reset();
            }
        }
    }

    private static class LocationHandle
    implements Location.Handle {
        private File mFile;
        private Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        public Location resolve() {
            Position pos = this.mNode.getPosition();
            return Location.create((File)this.mFile, null, (int)pos.getStart(), (int)pos.getEnd());
        }

        public void setClientData(Object clientData) {
            this.mClientData = clientData;
        }

        public Object getClientData() {
            return this.mClientData;
        }
    }

    public static class EcjResult {
        private final INameEnvironment mNameEnvironment;
        private final LookupEnvironment mLookupEnvironment;
        private final Map<ICompilationUnit, CompilationUnitDeclaration> compilationUnits;

        public EcjResult(INameEnvironment nameEnvironment, LookupEnvironment lookupEnvironment, Map<ICompilationUnit, CompilationUnitDeclaration> compilationUnits) {
            this.mNameEnvironment = nameEnvironment;
            this.mLookupEnvironment = lookupEnvironment;
            this.compilationUnits = compilationUnits;
        }

        public Collection<CompilationUnitDeclaration> getCompilationUnits() {
            return this.compilationUnits.values();
        }

        public CompilationUnitDeclaration getCompilationUnit(ICompilationUnit sourceUnit) {
            return this.compilationUnits.get(sourceUnit);
        }

        void removeCompilationUnit(ICompilationUnit sourceUnit) {
            this.compilationUnits.remove(sourceUnit);
        }

        public void dispose() {
            if (this.mNameEnvironment != null) {
                this.mNameEnvironment.cleanup();
            }
            if (this.mLookupEnvironment != null) {
                this.mLookupEnvironment.reset();
            }
            this.compilationUnits.clear();
        }
    }
}

