/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack.lang.codeinsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.tasks.youtrack.YouTrackIntellisense;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class YouTrackCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(YouTrackCompletionContributor.class);
    private static final int TIMEOUT = 2000;
    private static final InsertHandler<LookupElement> INSERT_HANDLER = new MyInsertHandler();

    public void fillCompletionVariants(final @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/tasks/youtrack/lang/codeinsight/YouTrackCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/tasks/youtrack/lang/codeinsight/YouTrackCompletionContributor", "fillCompletionVariants"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(DebugUtil.psiToString((PsiElement)parameters.getOriginalFile(), (boolean)true));
        }
        super.fillCompletionVariants(parameters, result);
        PsiFile file = parameters.getOriginalFile();
        final YouTrackIntellisense intellisense = (YouTrackIntellisense)file.getUserData(YouTrackIntellisense.INTELLISENSE_KEY);
        if (intellisense == null) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        Future future = application.executeOnPooledThread((Callable)new Callable<List<YouTrackIntellisense.CompletionItem>>(){

            @Override
            public List<YouTrackIntellisense.CompletionItem> call() throws Exception {
                return intellisense.fetchCompletion(parameters.getOriginalFile().getText(), parameters.getOffset());
            }
        });
        try {
            List suggestions = (List)future.get(2000L, TimeUnit.MILLISECONDS);
            result = result.withPrefixMatcher(YouTrackCompletionContributor.extractPrefix(parameters)).caseInsensitive();
            result.addAllElements((Iterable)ContainerUtil.map((Collection)suggestions, (Function)new Function<YouTrackIntellisense.CompletionItem, LookupElement>(){

                public LookupElement fun(YouTrackIntellisense.CompletionItem item) {
                    return LookupElementBuilder.create((Object)item, (String)item.getOption()).withTypeText(item.getDescription(), true).withInsertHandler(INSERT_HANDLER).withBoldness(item.getStyleClass().equals("keyword"));
                }
            }));
        }
        catch (Exception ignored) {
            if (ignored instanceof TimeoutException) {
                LOG.debug(String.format("YouTrack request took more than %d ms to complete", 2000));
            }
            LOG.debug((Throwable)ignored);
        }
    }

    @NotNull
    private static String extractPrefix(CompletionParameters parameters) {
        int prefixStart;
        String text = parameters.getOriginalFile().getText();
        int caretOffset = parameters.getOffset();
        if (text.isEmpty() || caretOffset == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/lang/codeinsight/YouTrackCompletionContributor", "extractPrefix"));
            }
            return "";
        }
        int stopAt = text.lastIndexOf(123, caretOffset - 1);
        if (stopAt <= text.lastIndexOf(125, caretOffset - 1)) {
            stopAt = text.charAt(caretOffset - 1) == ':' ? caretOffset - 1 : text.lastIndexOf(32, caretOffset - 1);
        }
        if ((prefixStart = stopAt + 1) < caretOffset && text.charAt(prefixStart) == '#') {
            ++prefixStart;
        }
        String string = StringUtil.trimLeading((String)text.substring(prefixStart, caretOffset));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/lang/codeinsight/YouTrackCompletionContributor", "extractPrefix"));
        }
        return string;
    }

    static boolean hasPrefixAt(String text, int offset, String prefix) {
        if (text.isEmpty() || offset < 0 || offset >= text.length()) {
            return false;
        }
        return text.regionMatches(true, offset, prefix, 0, prefix.length());
    }

    private static class MyInsertHandler
    implements InsertHandler<LookupElement> {
        private MyInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            int offset;
            YouTrackIntellisense.CompletionItem completionItem = (YouTrackIntellisense.CompletionItem)item.getObject();
            Document document = context.getDocument();
            Editor editor = context.getEditor();
            context.commitDocument();
            context.setAddCompletionChar(false);
            String prefix = completionItem.getPrefix();
            String suffix = completionItem.getSuffix();
            String text = document.getText();
            if (prefix.endsWith("{")) {
                for (offset = context.getStartOffset(); offset > prefix.length() && Character.isWhitespace(text.charAt(offset - 1)); --offset) {
                }
            }
            if (!prefix.isEmpty() && !YouTrackCompletionContributor.hasPrefixAt(document.getText(), offset - prefix.length(), prefix)) {
                document.insertString(offset, (CharSequence)prefix);
            }
            text = document.getText();
            if (suffix.startsWith("} ")) {
                for (offset = context.getTailOffset(); offset < text.length() - suffix.length() && Character.isWhitespace(text.charAt(offset)); ++offset) {
                }
            }
            if (!suffix.isEmpty() && !YouTrackCompletionContributor.hasPrefixAt(text, offset, suffix)) {
                document.insertString(offset, (CharSequence)suffix);
            }
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
    }
}

