/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.CommonBundle;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.apache.commons.httpclient.HttpStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class TaskBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "com.intellij.tasks.TaskBundle";

    private TaskBundle() {
    }

    public static String message(@NotNull @PropertyKey(resourceBundle="com.intellij.tasks.TaskBundle") String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/tasks/TaskBundle", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/tasks/TaskBundle", "message"));
        }
        return CommonBundle.message((ResourceBundle)TaskBundle.getBundle(), (String)key, (Object[])params);
    }

    @NotNull
    public static String messageForStatusCode(int statusCode) {
        if (statusCode == 401) {
            String string = TaskBundle.message("failure.login", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/TaskBundle", "messageForStatusCode"));
            }
            return string;
        }
        if (statusCode == 403) {
            String string = TaskBundle.message("failure.permissions", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/TaskBundle", "messageForStatusCode"));
            }
            return string;
        }
        String string = TaskBundle.message("failure.http.error", statusCode, HttpStatus.getStatusText((int)statusCode));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/TaskBundle", "messageForStatusCode"));
        }
        return string;
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new SoftReference((Object)bundle);
        }
        return bundle;
    }
}

