/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockFileOp
implements FileOp {
    private final Map<String, FileInfo> mExistingFiles = Maps.newTreeMap();
    private final Set<String> mExistingFolders = Sets.newTreeSet();
    private final Set<String> mReadOnlyFiles = Sets.newTreeSet();
    private final List<StringOutputStream> mOutputStreams = new ArrayList<StringOutputStream>();
    private boolean mIsWindows = FileOpUtils.create().isWindows();

    public void reset() {
        this.mExistingFiles.clear();
        this.mExistingFolders.clear();
        this.mReadOnlyFiles.clear();
        this.mOutputStreams.clear();
        this.mIsWindows = FileOpUtils.create().isWindows();
    }

    @Override
    public boolean isWindows() {
        return this.mIsWindows;
    }

    @Override
    public String toString(File f, Charset c) throws IOException {
        FileInfo fileInfo = this.mExistingFiles.get(f.getAbsolutePath());
        if (fileInfo == null || fileInfo.getContent() == null) {
            throw new FileNotFoundException();
        }
        return new String(fileInfo.getContent(), c);
    }

    @Override
    public String[] list(File folder, FilenameFilter filenameFilter) {
        File[] contents = this.listFiles(folder);
        String[] names = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            names[i] = contents[i].getName();
        }
        if (filenameFilter == null) {
            return names;
        }
        ArrayList result = Lists.newArrayList();
        for (String name : names) {
            if (!filenameFilter.accept(folder, name)) continue;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public File[] listFiles(File folder, FilenameFilter filenameFilter) {
        File[] contents = this.listFiles(folder);
        if (filenameFilter == null) {
            return contents;
        }
        ArrayList result = Lists.newArrayList();
        for (File f : contents) {
            if (!filenameFilter.accept(folder, f.getName())) continue;
            result.add(f);
        }
        return result.toArray(new File[result.size()]);
    }

    @Override
    public void deleteOnExit(File file) {
    }

    public void setIsWindows(boolean isWindows) {
        this.mIsWindows = isWindows;
    }

    public String getAgnosticAbsPath(File file) {
        return this.getAgnosticAbsPath(file.getAbsolutePath());
    }

    public String getAgnosticAbsPath(String path) {
        if (this.isWindows()) {
            path = path.replace('\\', '/');
            path = path.replaceAll("^[A-Z]:", "");
        }
        return path;
    }

    public void recordExistingFile(File file) {
        this.recordExistingFile(this.getAgnosticAbsPath(file), 0L, (byte[])null);
    }

    public void recordExistingFile(String absFilePath) {
        this.recordExistingFile(absFilePath, 0L, (byte[])null);
    }

    public void recordExistingFile(String absFilePath, byte[] inputStream) {
        this.recordExistingFile(absFilePath, 0L, inputStream);
    }

    public void recordExistingFile(String absFilePath, String content) {
        this.recordExistingFile(absFilePath, 0L, content.getBytes(Charsets.UTF_8));
    }

    public void recordExistingFile(String absFilePath, long lastModified, byte[] inputStream) {
        this.mExistingFiles.put(absFilePath, new FileInfo(lastModified, inputStream));
        this.createParents(absFilePath);
    }

    private void createParents(String absFilePath) {
        if (!absFilePath.endsWith("/")) {
            absFilePath = absFilePath.substring(0, absFilePath.lastIndexOf(47));
        }
        if (absFilePath.contains("/")) {
            this.recordExistingFolder(absFilePath);
        }
    }

    public void recordExistingFile(String absFilePath, long lastModified, String content) {
        this.recordExistingFile(absFilePath, lastModified, content.getBytes(Charsets.UTF_8));
    }

    public void recordExistingFolder(File folder) {
        this.recordExistingFolder(this.getAgnosticAbsPath(folder));
    }

    public void recordExistingFolder(String absFolderPath) {
        this.mExistingFolders.add(absFolderPath);
        this.createParents(absFolderPath);
    }

    public boolean hasRecordedExistingFile(File file) {
        return this.mExistingFiles.containsKey(this.getAgnosticAbsPath(file));
    }

    public boolean hasRecordedExistingFolder(File folder) {
        return this.mExistingFolders.contains(this.getAgnosticAbsPath(folder));
    }

    public String[] getExistingFiles() {
        Set<String> files = this.mExistingFiles.keySet();
        return files.toArray(new String[files.size()]);
    }

    public String[] getExistingFolders() {
        return this.mExistingFolders.toArray(new String[this.mExistingFolders.size()]);
    }

    public String[] getOutputStreams() {
        int n = this.mOutputStreams.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = this.mOutputStreams.get(i).toString();
        }
        return result;
    }

    @Override
    public void deleteFileOrFolder(File fileOrFolder) {
        if (this.isDirectory(fileOrFolder)) {
            for (File item : this.listFiles(fileOrFolder)) {
                this.deleteFileOrFolder(item);
            }
        }
        this.delete(fileOrFolder);
    }

    @Override
    public void setExecutablePermission(File file) throws IOException {
    }

    @Override
    public boolean canExecute(File file) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File ensureRealFile(File in) throws IOException {
        if (!this.exists(in)) {
            return in;
        }
        File result = File.createTempFile("MockFileOp", null);
        result.deleteOnExit();
        FileOutputStream os = new FileOutputStream(result);
        try {
            ByteStreams.copy((InputStream)this.newFileInputStream(in), (OutputStream)os);
        }
        finally {
            ((OutputStream)os).close();
        }
        return result;
    }

    @Override
    public void setReadOnly(File file) {
        this.mReadOnlyFiles.add(this.getAgnosticAbsPath(file));
        this.recordExistingFile(file);
    }

    @Override
    public void copyFile(File source, File dest) throws IOException {
        int c;
        InputStream in = this.newFileInputStream(source);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            baos.write(c);
        }
        in.close();
        baos.close();
        this.recordExistingFile(dest.getAbsolutePath(), baos.toByteArray());
    }

    @Override
    public boolean isSameFile(File file1, File file2) throws IOException {
        String path1 = this.getAgnosticAbsPath(file1);
        String path2 = this.getAgnosticAbsPath(file2);
        FileInfo fi1 = this.mExistingFiles.get(path1);
        FileInfo fi2 = this.mExistingFiles.get(path2);
        if (fi1 == null) {
            throw new FileNotFoundException("[isSameFile] Mock file not defined: " + path1);
        }
        if (fi1 == fi2) {
            return true;
        }
        if (fi2 == null) {
            throw new FileNotFoundException("[isSameFile] Mock file not defined: " + path2);
        }
        byte[] content1 = fi1.getContent();
        byte[] content2 = fi2.getContent();
        if (content1 == null) {
            throw new IOException("[isSameFile] Mock file has no content: " + path1);
        }
        if (content2 == null) {
            throw new IOException("[isSameFile] Mock file has no content: " + path2);
        }
        return Arrays.equals(content1, content2);
    }

    @Override
    public boolean isFile(File file) {
        String path = this.getAgnosticAbsPath(file);
        return this.mExistingFiles.containsKey(path);
    }

    @Override
    public boolean isDirectory(File file) {
        String path = this.getAgnosticAbsPath(file);
        if (this.mExistingFolders.contains(path)) {
            return true;
        }
        Pattern pathRE = Pattern.compile(Pattern.quote(path + (path.endsWith("/") ? "" : Character.valueOf('/'))) + ".*");
        for (String folder : this.mExistingFolders) {
            if (!pathRE.matcher(folder).matches()) continue;
            return true;
        }
        for (String filePath : this.mExistingFiles.keySet()) {
            if (!pathRE.matcher(filePath).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite(File file) {
        return !this.mReadOnlyFiles.contains(this.getAgnosticAbsPath(file));
    }

    @Override
    public boolean exists(File file) {
        return this.isFile(file) || this.isDirectory(file);
    }

    @Override
    public long length(File file) {
        throw new UnsupportedOperationException("MockFileUtils.length is not supported.");
    }

    @Override
    public boolean delete(File file) {
        String path = this.getAgnosticAbsPath(file);
        if (this.mExistingFiles.remove(path) != null) {
            return true;
        }
        for (String folder : this.mExistingFolders) {
            if (!folder.startsWith(path) || folder.equals(path)) continue;
            return false;
        }
        for (String filePath : this.mExistingFiles.keySet()) {
            if (!filePath.startsWith(path) || filePath.equals(path)) continue;
            return false;
        }
        return this.mExistingFolders.remove(path);
    }

    @Override
    public boolean mkdirs(File file) {
        while (file != null) {
            String path = this.getAgnosticAbsPath(file);
            this.mExistingFolders.add(path);
            file = file.getParentFile();
        }
        return true;
    }

    @Override
    public File[] listFiles(File file) {
        TreeSet<File> files = new TreeSet<File>();
        String path = this.getAgnosticAbsPath(file);
        Pattern pathRE = Pattern.compile(Pattern.quote(path + (path.endsWith("/") ? "" : Character.valueOf('/'))) + "[^/]*");
        for (String folder : this.mExistingFolders) {
            if (!pathRE.matcher(folder).matches()) continue;
            files.add(new File(folder));
        }
        for (String filePath : this.mExistingFiles.keySet()) {
            if (!pathRE.matcher(filePath).matches()) continue;
            files.add(new File(filePath));
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public boolean renameTo(File oldFile, File newFile) {
        boolean renamed = false;
        String oldPath = this.getAgnosticAbsPath(oldFile);
        String newPath = this.getAgnosticAbsPath(newFile);
        Pattern pathRE = Pattern.compile("^(" + Pattern.quote(oldPath) + ")($|/.*)");
        TreeSet newFolders = Sets.newTreeSet();
        Iterator<String> it = this.mExistingFolders.iterator();
        while (it.hasNext()) {
            String folder = it.next();
            Matcher m = pathRE.matcher(folder);
            if (!m.matches()) continue;
            it.remove();
            String newFolder = newPath + m.group(2);
            newFolders.add(newFolder);
            renamed = true;
        }
        this.mExistingFolders.addAll(newFolders);
        newFolders.clear();
        TreeMap newFiles = Maps.newTreeMap();
        Iterator<Map.Entry<String, FileInfo>> it2 = this.mExistingFiles.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<String, FileInfo> entry = it2.next();
            String filePath = entry.getKey();
            Matcher m = pathRE.matcher(filePath);
            if (!m.matches()) continue;
            it2.remove();
            String newFilePath = newPath + m.group(2);
            newFiles.put(newFilePath, entry.getValue());
            renamed = true;
        }
        this.mExistingFiles.putAll(newFiles);
        return renamed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties loadProperties(File file) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProperties(File file, Properties props, String comments) throws IOException {
        OutputStream fos = null;
        try {
            fos = this.newFileOutputStream(file);
            props.store(fos, comments);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public OutputStream newFileOutputStream(File file) throws FileNotFoundException {
        StringOutputStream os = new StringOutputStream(file);
        this.mOutputStreams.add(os);
        return os;
    }

    @Override
    public InputStream newFileInputStream(File file) throws FileNotFoundException {
        byte[] content;
        FileInfo fi = this.mExistingFiles.get(this.getAgnosticAbsPath(file));
        if (fi != null && (content = fi.getContent()) != null) {
            return new ByteArrayInputStream(content);
        }
        throw new FileNotFoundException("Mock file has no content: " + this.getAgnosticAbsPath(file));
    }

    @Override
    public long lastModified(File file) {
        FileInfo fi = this.mExistingFiles.get(this.getAgnosticAbsPath(file));
        if (fi != null) {
            return fi.getLastModified();
        }
        return 0L;
    }

    @Override
    public boolean createNewFile(File file) throws IOException {
        if (this.exists(file)) {
            return false;
        }
        this.recordExistingFile(file);
        return true;
    }

    private static class FileInfo {
        private long mLastModified;
        private byte[] mContent;

        public FileInfo(long lastModified, byte[] content) {
            this.mLastModified = lastModified;
            this.mContent = content;
        }

        public long getLastModified() {
            return this.mLastModified;
        }

        public byte[] getContent() {
            return this.mContent;
        }
    }

    public class StringOutputStream
    extends ByteArrayOutputStream {
        private String mData;
        private final File mFile;

        public StringOutputStream(File file) {
            this.mFile = file;
            MockFileOp.this.recordExistingFile(file);
        }

        public File getFile() {
            return this.mFile;
        }

        public String getData() {
            return this.mData;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.mData = new String(this.toByteArray(), "UTF-8");
            MockFileOp.this.recordExistingFile(this.mFile.getAbsolutePath(), this.mData);
        }

        @Override
        public synchronized String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('<').append(MockFileOp.this.getAgnosticAbsPath(this.mFile)).append(": ");
            if (this.mData == null) {
                sb.append("(stream not closed properly)>");
            } else {
                sb.append('\'').append(this.mData).append("'>");
            }
            return sb.toString();
        }
    }
}

