/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.nativeplatform.NativeBinarySpec;

public class StripDebugSymbolTask
extends DefaultTask {
    private File stripExecutable;
    private File inputFolder;
    private Collection<File> inputFiles = Lists.newArrayList();
    private File outputFolder;

    @Input
    public File getStripExecutable() {
        return this.stripExecutable;
    }

    public void setStripExecutable(File stripExecutable) {
        this.stripExecutable = stripExecutable;
    }

    @InputDirectory
    public File getInputFolder() {
        return this.inputFolder;
    }

    public void setInputFolder(File inputFolder) {
        this.inputFolder = inputFolder;
    }

    @InputFiles
    public Collection<File> getInputFiles() {
        return this.inputFiles;
    }

    @OutputDirectory
    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    @TaskAction
    void taskAction(IncrementalTaskInputs inputs) throws IOException {
        inputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                File input = inputFileDetails.getFile();
                File output = new File(StripDebugSymbolTask.this.getOutputFolder(), input.getName());
                StripDebugSymbolTask.this.stripFile(input, output);
            }
        });
        inputs.removed((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                File input = inputFileDetails.getFile();
                File output = new File(StripDebugSymbolTask.this.getOutputFolder(), input.getName());
                try {
                    FileUtils.deleteIfExists((File)output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void stripFile(File input, File output) {
        boolean result;
        if (!this.getOutputFolder().exists() && !(result = this.getOutputFolder().mkdirs())) {
            throw new RuntimeException("Unabled to create directory '" + this.getOutputFolder().toString() + "' for native binaries.");
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getStripExecutable());
        builder.addArgs("--strip-unneeded");
        builder.addArgs("-o");
        builder.addArgs(output.toString());
        builder.addArgs(input.toString());
        new GradleProcessExecutor(this.getProject()).execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(this.getLogger())));
    }

    public static class ConfigAction
    implements Action<StripDebugSymbolTask> {
        private final NativeBinarySpec binary;
        private final File inputFolder;
        private final Collection<File> inputFiles;
        private final File buildDir;
        private final NdkHandler handler;

        public ConfigAction(NativeBinarySpec binary, File inputFolder, Collection<File> inputFiles, File buildDir, NdkHandler handler) {
            this.binary = binary;
            this.inputFolder = inputFolder;
            this.inputFiles = inputFiles;
            this.buildDir = buildDir;
            this.handler = handler;
        }

        public void execute(StripDebugSymbolTask task) {
            task.setInputFolder(this.inputFolder);
            task.getInputFiles().addAll(this.inputFiles);
            task.setOutputFolder(new File(this.buildDir, NdkNamingScheme.getOutputDirectoryName(this.binary)));
            task.setStripExecutable(this.handler.getStripCommand(Abi.getByName((String)this.binary.getTargetPlatform().getName())));
            task.dependsOn(new Object[]{this.binary});
        }
    }
}

