/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.model.NativeAndroidProjectImpl;
import com.android.build.gradle.internal.model.NativeArtifactImpl;
import com.android.build.gradle.internal.model.NativeFileImpl;
import com.android.build.gradle.internal.model.NativeFolderImpl;
import com.android.build.gradle.internal.model.NativeSettingsImpl;
import com.android.build.gradle.internal.model.NativeToolchainImpl;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.managed.NativeSourceFile;
import com.android.build.gradle.managed.NativeSourceFolder;
import com.android.build.gradle.managed.NativeToolchain;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class NativeComponentModelBuilder
implements ToolingModelBuilder {
    ModelRegistry registry;
    Map<List<String>, NativeSettings> settingsMap = Maps.newHashMap();
    int settingIndex = 0;
    NativeBuildConfig config;

    public NativeComponentModelBuilder(ModelRegistry registry) {
        this.registry = registry;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(NativeAndroidProject.class.getName());
    }

    private void initialize() {
        this.config = (NativeBuildConfig)this.registry.realize(new ModelPath("nativeBuildConfig"), ModelType.of(NativeBuildConfig.class));
        this.settingIndex = 0;
    }

    public Object buildAll(String modelName, Project project) {
        this.initialize();
        List<NativeArtifact> artifacts = this.createNativeArtifacts();
        List<com.android.builder.model.NativeToolchain> toolchains = this.createNativeToolchains();
        ImmutableList settings = ImmutableList.copyOf(this.settingsMap.values());
        Map<String, String> extensions = this.createFileExtensionMap();
        return new NativeAndroidProjectImpl("2.1.0-beta3", project.getName(), (Collection)ImmutableList.copyOf(this.config.getBuildFiles()), artifacts, toolchains, (Collection)settings, extensions, 0);
    }

    private List<NativeArtifact> createNativeArtifacts() {
        ArrayList artifacts = Lists.newArrayList();
        for (NativeLibrary lib : this.config.getLibraries()) {
            ArrayList folders = Lists.newArrayList();
            for (NativeSourceFolder src : lib.getFolders()) {
                folders.add(new NativeFolderImpl(src.getSrc(), (Map)ImmutableMap.of((Object)"c", (Object)this.getSettingsName(src.getCFlags()), (Object)"c++", (Object)this.getSettingsName(src.getCppFlags())), src.getWorkingDirectory()));
            }
            ArrayList files = Lists.newArrayList();
            for (NativeSourceFile src : lib.getFiles()) {
                files.add(new NativeFileImpl(src.getSrc(), this.getSettingsName(src.getFlags()), src.getWorkingDirectory()));
            }
            NativeArtifactImpl artifact = new NativeArtifactImpl(lib.getName(), lib.getToolchain(), (String)Objects.firstNonNull((Object)lib.getGroupName(), (Object)""), (Collection)folders, (Collection)files, (Collection)ImmutableList.copyOf(lib.getExportedHeaders()), lib.getOutput());
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private String getSettingsName(List<String> flags) {
        ImmutableList flagsCopy = ImmutableList.copyOf(flags);
        NativeSettings setting = this.settingsMap.get(flags);
        if (setting == null) {
            setting = new NativeSettingsImpl("setting" + this.settingIndex, (List)flagsCopy);
            this.settingsMap.put((List<String>)flagsCopy, setting);
            ++this.settingIndex;
        }
        return setting.getName();
    }

    private List<com.android.builder.model.NativeToolchain> createNativeToolchains() {
        ArrayList toolchains = Lists.newArrayList();
        for (NativeToolchain toolchain : this.config.getToolchains().values()) {
            toolchains.add(new NativeToolchainImpl(toolchain.getName(), toolchain.getCCompilerExecutable(), toolchain.getCppCompilerExecutable()));
        }
        return toolchains;
    }

    private Map<String, String> createFileExtensionMap() {
        HashMap extensions = Maps.newHashMap();
        for (String ext : this.config.getCFileExtensions()) {
            extensions.put(ext, "c");
        }
        for (String ext : this.config.getCppFileExtensions()) {
            extensions.put(ext, "c++");
        }
        return extensions;
    }
}

