/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.shell;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.GrTopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.shell.GroovyShellCodeFragment;

public class GroovyShellLanguageConsoleView
extends LanguageConsoleImpl {
    public GroovyShellLanguageConsoleView(Project project, String name) {
        super(new LanguageConsoleImpl.Helper(project, (VirtualFile)new LightVirtualFile(name, (Language)GroovyLanguage.INSTANCE, (CharSequence)"")){

            @NotNull
            public PsiFile getFile() {
                GroovyShellCodeFragment groovyShellCodeFragment = new GroovyShellCodeFragment(this.project, (LightVirtualFile)this.virtualFile);
                if (groovyShellCodeFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView$1", "getFile"));
                }
                return groovyShellCodeFragment;
            }
        });
    }

    protected void processCode() {
        GroovyShellCodeFragment groovyFile = this.getGroovyFile();
        for (GrTopStatement statement : groovyFile.getTopStatements()) {
            if (statement instanceof GrImportStatement) {
                groovyFile.addImportsFromString(GroovyShellLanguageConsoleView.importToString((GrImportStatement)statement));
                continue;
            }
            if (statement instanceof GrMethod) {
                groovyFile.addVariable(((GrMethod)statement).getName(), this.generateClosure((GrMethod)statement));
                continue;
            }
            if (statement instanceof GrAssignmentExpression) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
                GrExpression left = assignment.getLValue();
                if (!(left instanceof GrReferenceExpression) || ((GrReferenceExpression)left).isQualified()) continue;
                groovyFile.addVariable(((GrReferenceExpression)left).getReferenceName(), assignment.getRValue());
                continue;
            }
            if (!(statement instanceof GrTypeDefinition)) continue;
            groovyFile.addTypeDefinition(this.prepareTypeDefinition((GrTypeDefinition)statement));
        }
        PsiType scriptType = groovyFile.getInferredScriptReturnType();
        if (scriptType != null) {
            groovyFile.addVariable("_", scriptType);
        }
    }

    @NotNull
    public GroovyShellCodeFragment getGroovyFile() {
        GroovyShellCodeFragment groovyShellCodeFragment = (GroovyShellCodeFragment)this.getFile();
        if (groovyShellCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "getGroovyFile"));
        }
        return groovyShellCodeFragment;
    }

    @NotNull
    private GrTypeDefinition prepareTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "prepareTypeDefinition"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        GroovyFile file = factory.createGroovyFile("", false, (PsiElement)this.getFile());
        GrTypeDefinition grTypeDefinition = (GrTypeDefinition)file.add(typeDefinition);
        if (grTypeDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "prepareTypeDefinition"));
        }
        return grTypeDefinition;
    }

    @NotNull
    private GrClosableBlock generateClosure(@NotNull GrMethod method) {
        GrParameter[] parameters;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "generateClosure"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (GrParameter parameter : parameters = method.getParameters()) {
            buffer.append(parameter.getText());
            buffer.append(',');
        }
        if (parameters.length > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        buffer.append("->}");
        GrClosableBlock grClosableBlock = factory.createClosureFromText(buffer.toString(), (PsiElement)this.getFile());
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "generateClosure"));
        }
        return grClosableBlock;
    }

    @Nullable
    private static String importToString(@NotNull GrImportStatement anImport) {
        if (anImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anImport", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "importToString"));
        }
        StringBuilder buffer = new StringBuilder();
        GrCodeReferenceElement reference = anImport.getImportReference();
        if (reference == null) {
            return null;
        }
        String qname = reference.getClassNameText();
        buffer.append(qname);
        if (!anImport.isOnDemand()) {
            String importedName = anImport.getImportedName();
            buffer.append(":").append(importedName);
        }
        return buffer.toString();
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "addToHistoryInner"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "addToHistoryInner"));
        }
        String result = super.addToHistoryInner(textRange, editor, erase, preserveMarkup);
        if ("purge variables".equals(result.trim())) {
            this.clearVariables();
        } else if ("purge classes".equals(result.trim())) {
            this.clearClasses();
        } else if ("purge imports".equals(result.trim())) {
            this.clearImports();
        } else if ("purge all".equals(result.trim())) {
            this.clearVariables();
            this.clearClasses();
            this.clearImports();
        } else {
            this.processCode();
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/shell/GroovyShellLanguageConsoleView", "addToHistoryInner"));
        }
        return string;
    }

    private void clearVariables() {
        this.getGroovyFile().clearVariables();
    }

    private void clearClasses() {
        this.getGroovyFile().clearClasses();
    }

    private void clearImports() {
        this.getGroovyFile().clearImports();
    }
}

