/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.impl.light.LightMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegatedMethod
extends LightMethod
implements PsiMethod,
PsiMirrorElement,
OriginInfoAwareElement {
    private final PsiMethod myPrototype;

    public DelegatedMethod(@NotNull PsiMethod delegate, @NotNull PsiMethod prototype) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/plugins/groovy/lang/resolve/ast/DelegatedMethod", "<init>"));
        }
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "org/jetbrains/plugins/groovy/lang/resolve/ast/DelegatedMethod", "<init>"));
        }
        super(prototype.getManager(), delegate, delegate.getContainingClass(), delegate.getLanguage());
        this.myPrototype = prototype;
        this.setNavigationElement((PsiElement)this.myPrototype);
    }

    @NotNull
    public PsiMethod getPrototype() {
        PsiMethod psiMethod = this.myPrototype;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/ast/DelegatedMethod", "getPrototype"));
        }
        return psiMethod;
    }

    @Nullable
    public String getOriginInfo() {
        PsiClass aClass = this.myPrototype.getContainingClass();
        if (aClass != null && aClass.getName() != null) {
            return "delegates to " + aClass.getName();
        }
        return null;
    }
}

