/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.arguments;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrArgumentListImpl
extends GroovyPsiElementImpl
implements GrArgumentList {
    public GrArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitArgumentList(this);
    }

    public String toString() {
        return "Arguments";
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        ArrayList<GrNamedArgument> result = new ArrayList<GrNamedArgument>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrNamedArgument)) continue;
            result.add((GrNamedArgument)cur);
        }
        GrNamedArgument[] grNamedArgumentArray = result.toArray(new GrNamedArgument[result.size()]);
        if (grNamedArgumentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "getNamedArguments"));
        }
        return grNamedArgumentArray;
    }

    @Override
    public GrNamedArgument findNamedArgument(@NotNull String label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "findNamedArgument"));
        }
        return PsiImplUtil.findNamedArgument(this, label);
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        ArrayList<GrExpression> result = new ArrayList<GrExpression>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            result.add((GrExpression)cur);
        }
        GrExpression[] grExpressionArray = result.toArray(new GrExpression[result.size()]);
        if (grExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "getExpressionArguments"));
        }
        return grExpressionArray;
    }

    @Override
    @NotNull
    public GroovyPsiElement[] getAllArguments() {
        ArrayList<GroovyPsiElement> args = new ArrayList<GroovyPsiElement>();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GrNamedArgument) && !(child instanceof GrExpression)) continue;
            args.add((GroovyPsiElement)child);
        }
        GroovyPsiElement[] groovyPsiElementArray = (GroovyPsiElement[])ContainerUtil.toArray(args, (Object[])new GroovyPsiElement[args.size()]);
        if (groovyPsiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "getAllArguments"));
        }
        return groovyPsiElementArray;
    }

    @Override
    public GrArgumentList replaceWithArgumentList(GrArgumentList newArgList) throws IncorrectOperationException {
        if (this.getParent() == null || this.getParent().getNode() == null) {
            throw new IncorrectOperationException();
        }
        ASTNode parentNode = this.getParent().getNode();
        ASTNode newNode = newArgList.getNode();
        assert (parentNode != null);
        parentNode.replaceChild(this.getNode(), newNode);
        if (!(newNode.getPsi() instanceof GrArgumentList)) {
            throw new IncorrectOperationException();
        }
        return (GrArgumentList)newNode.getPsi();
    }

    @Override
    @Nullable
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mLPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    @Override
    @Nullable
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyTokenTypes.mRPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    @Override
    public int getExpressionArgumentIndex(GrExpression arg) {
        int res = 0;
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            if (arg == cur) {
                return res;
            }
            ++res;
        }
        return -1;
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) {
        GrNamedArgument[] namedArguments = this.getNamedArguments();
        GrExpression[] args = this.getExpressionArguments();
        GroovyPsiElement anchor = null;
        int namedCount = namedArguments.length;
        int exprCount = args.length;
        if (namedCount > 0) {
            anchor = namedArguments[namedCount - 1];
        } else if (exprCount > 0) {
            anchor = args[exprCount - 1];
        }
        anchor = anchor != null ? PsiUtil.getNextNonSpace(anchor) : this.getRightParen();
        this.addBefore(namedArgument, anchor);
        return namedArgument;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "add"));
        }
        return this.addBefore(element, null);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "addBefore"));
        }
        if (element instanceof GrNamedArgument || element instanceof GrExpression) {
            if (anchor == null) {
                anchor = this.getLastChild();
            }
            if (anchor == null) {
                return super.addBefore(element, anchor);
            }
            for (anchor = anchor.getPrevSibling(); anchor != null && !(anchor instanceof GrExpression) && !(anchor instanceof GrNamedArgument); anchor = anchor.getPrevSibling()) {
            }
            return this.addAfter(element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "addAfter"));
        }
        if (element instanceof GrExpression || element instanceof GrNamedArgument) {
            boolean insertComma;
            boolean bl = insertComma = this.getAllArguments().length != 0;
            if (anchor == null) {
                anchor = this.getLeftParen();
            }
            PsiElement result = super.addAfter(element, anchor);
            if (insertComma) {
                ASTNode astNode = this.getNode();
                if (anchor == this.getLeftParen()) {
                    astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result.getNextSibling().getNode());
                } else {
                    astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", result.getNode());
                }
                CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat((PsiElement)this);
            }
            return result;
        }
        return super.addAfter(element, anchor);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "deleteChildInternal"));
        }
        PsiElement element = child.getPsi();
        if (element instanceof GrExpression || element instanceof GrNamedArgument) {
            ASTNode prev = TreeUtil.skipElementsBack((ASTNode)child.getTreePrev(), (TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS);
            if (prev != null && prev.getElementType() == GroovyTokenTypes.mCOMMA) {
                ASTNode pprev = prev.getTreePrev();
                if (pprev != null && PsiImplUtil.isWhiteSpaceOrNls(pprev)) {
                    super.deleteChildInternal(pprev);
                }
                super.deleteChildInternal(prev);
            } else {
                ASTNode next = TreeUtil.skipElements((ASTNode)child.getTreeNext(), (TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS);
                if (next != null && next.getElementType() == GroovyTokenTypes.mCOMMA) {
                    ASTNode nnext = next.getTreeNext();
                    if (nnext != null && PsiImplUtil.isWhiteSpaceOrNls(nnext)) {
                        super.deleteChildInternal(nnext);
                    }
                    super.deleteChildInternal(next);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @NotNull
    public PsiExpression[] getExpressions() {
        if (PsiExpression.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "getExpressions"));
        }
        return PsiExpression.EMPTY_ARRAY;
    }

    @NotNull
    public PsiType[] getExpressionTypes() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/arguments/GrArgumentListImpl", "getExpressionTypes"));
        }
        return PsiType.EMPTY_ARRAY;
    }
}

