/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;

public class GrAnonymousClassType
extends GrLiteralClassType {
    private final GrAnonymousClassDefinition myAnonymous;

    public GrAnonymousClassType(@NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull GrAnonymousClassDefinition anonymous) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "<init>"));
        }
        if (anonymous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymous", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "<init>"));
        }
        super(languageLevel, scope, facade);
        this.myAnonymous = anonymous;
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        GrCodeReferenceElement ref = this.myAnonymous.getBaseClassReferenceGroovy();
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiClass) {
            String qname = ((PsiClass)resolved).getQualifiedName();
            String string = qname != null ? qname : ((PsiClass)resolved).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "getJavaClassName"));
            }
            return string;
        }
        String string = ref.getClassNameText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "getJavaClassName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = StringUtil.getShortName((String)this.getJavaClassName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "getClassName"));
        }
        return string;
    }

    @Override
    public GrAnonymousClassDefinition resolve() {
        return this.myAnonymous;
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.myAnonymous.getBaseClassReferenceGroovy().getTypeArguments();
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "getParameters"));
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "setLanguageLevel"));
        }
        GrAnonymousClassType grAnonymousClassType = new GrAnonymousClassType(languageLevel, this.myScope, this.myFacade, this.myAnonymous);
        if (grAnonymousClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "setLanguageLevel"));
        }
        return grAnonymousClassType;
    }

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "getInternalCanonicalText"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myAnonymous.isValid();
    }

    public String toString() {
        return "AnonymousType:" + this.getPresentableText();
    }

    @NotNull
    public PsiClassType getSimpleClassType() {
        GrClassReferenceType grClassReferenceType = new GrClassReferenceType(this.myAnonymous.getBaseClassReferenceGroovy(), this.myLanguageLevel);
        if (grClassReferenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrAnonymousClassType", "getSimpleClassType"));
        }
        return grClassReferenceType;
    }
}

