/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;

public class AnnotationArgConverter {
    @Nullable
    public GrAnnotationMemberValue convert(PsiAnnotationMemberValue value) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@A(");
        this.generateText(value, buffer);
        buffer.append(")");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(value.getProject());
        try {
            return factory.createAnnotationFromText(buffer.toString()).getParameterList().getAttributes()[0].getValue();
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private void generateText(PsiAnnotationMemberValue value, final StringBuilder buffer) {
        value.accept((PsiElementVisitor)new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                buffer.append("@");
                PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                if (ref == null) {
                    return;
                }
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiClass && ((PsiClass)resolved).getQualifiedName() != null) {
                    buffer.append(((PsiClass)resolved).getQualifiedName());
                } else {
                    buffer.append(ref.getText());
                }
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                parameterList.accept((PsiElementVisitor)this);
            }

            public void visitAnnotationParameterList(PsiAnnotationParameterList list) {
                PsiNameValuePair[] attributes = list.getAttributes();
                if (attributes.length > 0) {
                    buffer.append('(');
                    for (PsiNameValuePair attribute : attributes) {
                        attribute.accept((PsiElementVisitor)this);
                        buffer.append(',');
                    }
                    buffer.replace(buffer.length() - 1, buffer.length(), ")");
                }
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                String name = pair.getName();
                PsiAnnotationMemberValue value = pair.getValue();
                if (name != null) {
                    buffer.append(name);
                    buffer.append('=');
                }
                if (value != null) {
                    value.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(PsiExpression expression) {
                buffer.append(expression.getText());
            }

            public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
                PsiAnnotationMemberValue[] initializers = initializer.getInitializers();
                this.processInitializers(initializers);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
                if (arrayInitializer == null) {
                    super.visitNewExpression(expression);
                } else {
                    PsiType type = expression.getType();
                    if (type == null) {
                        type = PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope()).createArrayType();
                    }
                    buffer.append('(');
                    arrayInitializer.accept((PsiElementVisitor)this);
                    buffer.append(" as ");
                    buffer.append(type.getCanonicalText());
                    buffer.append(")");
                }
            }

            public void visitArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializer) {
                this.processInitializers((PsiAnnotationMemberValue[])arrayInitializer.getInitializers());
            }

            private void processInitializers(PsiAnnotationMemberValue[] initializers) {
                buffer.append('[');
                for (PsiAnnotationMemberValue initializer : initializers) {
                    initializer.accept((PsiElementVisitor)this);
                    buffer.append(',');
                }
                if (initializers.length > 0) {
                    buffer.delete(buffer.length() - 1, buffer.length());
                }
                buffer.append(']');
            }
        });
    }
}

