/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.formatter.GrControlStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.PropertyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class ControlFlowBuilderUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil");

    private ControlFlowBuilderUtil() {
    }

    public static int[] postorder(Instruction[] flow) {
        int[] result = new int[flow.length];
        boolean[] visited = new boolean[flow.length];
        for (int i = 0; i < result.length; ++i) {
            visited[i] = false;
        }
        int N = flow.length;
        for (int i = 0; i < flow.length; ++i) {
            if (visited[i]) continue;
            N = ControlFlowBuilderUtil.doVisitForPostorder(flow[i], N, result, visited);
        }
        LOG.assertTrue(N == 0);
        return result;
    }

    private static int doVisitForPostorder(Instruction curr, int currN, int[] postorder, boolean[] visited) {
        visited[curr.num()] = true;
        for (Instruction instruction : curr.allSuccessors()) {
            if (visited[instruction.num()]) continue;
            currN = ControlFlowBuilderUtil.doVisitForPostorder(instruction, currN, postorder, visited);
        }
        postorder[curr.num()] = --currN;
        return currN;
    }

    public static ReadWriteVariableInstruction[] getReadsWithoutPriorWrites(Instruction[] flow, boolean onlyFirstRead) {
        ArrayList<ReadWriteVariableInstruction> result = new ArrayList<ReadWriteVariableInstruction>();
        TObjectIntHashMap<String> namesIndex = ControlFlowBuilderUtil.buildNamesIndex(flow);
        TIntHashSet[] definitelyAssigned = new TIntHashSet[flow.length];
        int[] postorder = ControlFlowBuilderUtil.postorder(flow);
        int[] invpostorder = ControlFlowBuilderUtil.invPostorder(postorder);
        ControlFlowBuilderUtil.findReadsBeforeWrites(flow, definitelyAssigned, result, namesIndex, postorder, invpostorder, onlyFirstRead);
        if (result.isEmpty()) {
            return ReadWriteVariableInstruction.EMPTY_ARRAY;
        }
        return result.toArray(new ReadWriteVariableInstruction[result.size()]);
    }

    private static int[] invPostorder(int[] postorder) {
        int[] result = new int[postorder.length];
        for (int i = 0; i < postorder.length; ++i) {
            result[postorder[i]] = i;
        }
        return result;
    }

    private static TObjectIntHashMap<String> buildNamesIndex(Instruction[] flow) {
        TObjectIntHashMap namesIndex = new TObjectIntHashMap();
        int idx = 0;
        for (Instruction instruction : flow) {
            String name;
            if (!(instruction instanceof ReadWriteVariableInstruction) || namesIndex.contains((Object)(name = ((ReadWriteVariableInstruction)instruction).getVariableName()))) continue;
            namesIndex.put((Object)name, idx++);
        }
        return namesIndex;
    }

    private static void findReadsBeforeWrites(Instruction[] flow, TIntHashSet[] definitelyAssigned, List<ReadWriteVariableInstruction> result, TObjectIntHashMap<String> namesIndex, int[] postorder, int[] invpostorder, boolean onlyFirstRead) {
        int start;
        for (int i = start = ArrayUtil.find((int[])invpostorder, (int)0); i < flow.length; ++i) {
            int j = invpostorder[i];
            Instruction curr = flow[j];
            if (curr instanceof ReadWriteVariableInstruction) {
                ReadWriteVariableInstruction rw = (ReadWriteVariableInstruction)curr;
                int n = namesIndex.get((Object)rw.getVariableName());
                TIntHashSet vars = definitelyAssigned[j];
                if (rw.isWrite()) {
                    if (vars == null) {
                        definitelyAssigned[j] = vars = new TIntHashSet();
                    }
                    vars.add(n);
                } else if (vars == null || !vars.contains(n)) {
                    result.add(rw);
                    if (onlyFirstRead) {
                        if (vars == null) {
                            definitelyAssigned[j] = vars = new TIntHashSet();
                        }
                        vars.add(n);
                    }
                }
            }
            for (Instruction instruction : curr.allSuccessors()) {
                if (postorder[instruction.num()] <= postorder[curr.num()]) continue;
                TIntHashSet currDefinitelyAssigned = definitelyAssigned[curr.num()];
                TIntHashSet succDefinitelyAssigned = definitelyAssigned[instruction.num()];
                if (currDefinitelyAssigned != null) {
                    int[] currArray = currDefinitelyAssigned.toArray();
                    if (succDefinitelyAssigned == null) {
                        succDefinitelyAssigned = new TIntHashSet();
                        succDefinitelyAssigned.addAll(currArray);
                        definitelyAssigned[instruction.num()] = succDefinitelyAssigned;
                        continue;
                    }
                    succDefinitelyAssigned.retainAll(currArray);
                    continue;
                }
                if (succDefinitelyAssigned != null) {
                    succDefinitelyAssigned.clear();
                    continue;
                }
                definitelyAssigned[instruction.num()] = succDefinitelyAssigned = new TIntHashSet();
            }
        }
    }

    public static boolean isInstanceOfBinary(GrBinaryExpression binary) {
        if (binary.getOperationTokenType() == GroovyTokenTypes.kIN) {
            GrExpression left = binary.getLeftOperand();
            GrExpression right = binary.getRightOperand();
            if (left instanceof GrReferenceExpression && ((GrReferenceExpression)left).getQualifier() == null && right instanceof GrReferenceExpression && ControlFlowBuilderUtil.findClassByText((GrReferenceExpression)right)) {
                return true;
            }
        }
        return false;
    }

    private static boolean findClassByText(GrReferenceExpression ref) {
        String text = ref.getText();
        int i = text.indexOf(60);
        String className = i == -1 ? text : text.substring(0, i);
        PsiClass[] names = PsiShortNamesCache.getInstance((Project)ref.getProject()).getClassesByName(className, ref.getResolveScope());
        if (names.length > 0) {
            return true;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof GroovyFile) {
            GrImportStatement[] imports;
            for (GrImportStatement anImport : imports = ((GroovyFile)file).getImportStatements()) {
                if (!className.equals(anImport.getImportedName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCertainlyReturnStatement(GrStatement st) {
        PsiElement parent = st.getParent();
        if (parent instanceof GrOpenBlock) {
            if (st != ArrayUtil.getLastElement((Object[])((GrOpenBlock)parent).getStatements())) {
                return false;
            }
            PsiElement pparent = parent.getParent();
            if (pparent instanceof GrMethod) {
                return true;
            }
            if (pparent instanceof GrBlockStatement || pparent instanceof GrCatchClause || pparent instanceof GrLabeledStatement) {
                pparent = pparent.getParent();
            }
            if (pparent instanceof GrIfStatement || pparent instanceof GrControlStatement || pparent instanceof GrTryCatchStatement) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)pparent);
            }
        } else {
            if (parent instanceof GrClosableBlock) {
                return st == ArrayUtil.getLastElement((Object[])((GrClosableBlock)parent).getStatements());
            }
            if (parent instanceof GroovyFileBase) {
                return st == ArrayUtil.getLastElement((Object[])((GroovyFileBase)parent).getStatements());
            }
            if (parent instanceof GrForStatement || parent instanceof GrIfStatement && st != ((GrIfStatement)parent).getCondition() || parent instanceof GrSynchronizedStatement && st != ((GrSynchronizedStatement)parent).getMonitor() || parent instanceof GrWhileStatement && st != ((GrWhileStatement)parent).getCondition() || parent instanceof GrConditionalExpression && st != ((GrConditionalExpression)parent).getCondition() || parent instanceof GrElvisExpression) {
                return ControlFlowBuilderUtil.isCertainlyReturnStatement((GrStatement)parent);
            }
            if (parent instanceof GrCaseSection) {
                Object[] statements = ((GrCaseSection)parent).getStatements();
                GrStatement last = (GrStatement)ArrayUtil.getLastElement((Object[])statements);
                GrSwitchStatement switchStatement = (GrSwitchStatement)parent.getParent();
                if (last instanceof GrBreakStatement && statements.length > 1 && statements[statements.length - 2] == st) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchStatement);
                }
                if (st == last && (st instanceof GrBreakStatement || ControlFlowBuilderUtil.isLastStatementInCaseSection((GrCaseSection)parent, switchStatement))) {
                    return ControlFlowBuilderUtil.isCertainlyReturnStatement(switchStatement);
                }
            }
        }
        return false;
    }

    private static boolean isLastStatementInCaseSection(GrCaseSection caseSection, GrSwitchStatement switchStatement) {
        Object[] sections = switchStatement.getCaseSections();
        int i = ArrayUtilRt.find((Object[])sections, (Object)caseSection);
        if (i == sections.length - 1) {
            return true;
        }
        for (int j = i + 1; j < sections.length; ++j) {
            Object section = sections[j];
            for (GrStatement statement : section.getStatements()) {
                if (statement instanceof GrBreakStatement) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static GroovyResolveResult[] resolveNonQualifiedRefWithoutFlow(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil", "resolveNonQualifiedRefWithoutFlow"));
        }
        LOG.assertTrue(!ref.isQualified());
        String referenceName = ref.getReferenceName();
        PropertyResolverProcessor processor = new PropertyResolverProcessor(referenceName, ref);
        ResolveUtil.treeWalkUp(ref, processor, false);
        GroovyResolveResult[] candidates = ((ResolverProcessor)processor).getCandidates();
        if (candidates.length != 0) {
            if (candidates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil", "resolveNonQualifiedRefWithoutFlow"));
            }
            return candidates;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ControlFlowBuilderUtil", "resolveNonQualifiedRefWithoutFlow"));
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }
}

