/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrForBodyFixer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GrWhileBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrWhileBodyFixer", "apply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrWhileBodyFixer", "apply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrWhileBodyFixer", "apply"));
        }
        if (!(psiElement instanceof GrWhileStatement)) {
            return;
        }
        GrWhileStatement whileStatement = (GrWhileStatement)psiElement;
        Document doc = editor.getDocument();
        GrStatement body = whileStatement.getBody();
        if (body instanceof GrBlockStatement) {
            return;
        }
        if (body != null && GrForBodyFixer.startLine(editor.getDocument(), body) == GrForBodyFixer.startLine(editor.getDocument(), whileStatement) && whileStatement.getCondition() != null) {
            return;
        }
        PsiElement rParenth = whileStatement.getRParenth();
        assert (rParenth != null);
        doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
    }
}

