/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.geb;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.geb.GebUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class GebPageMemberContributor
extends NonCodeMembersContributor {
    @Override
    protected String getParentClassName() {
        return "geb.Page";
    }

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GrField f;
        PsiElement contentField;
        PsiElement grClosure;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/geb/GebPageMemberContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/geb/GebPageMemberContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/geb/GebPageMemberContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/geb/GebPageMemberContributor", "processDynamicElements"));
        }
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        if (classHint != null && !classHint.shouldProcess(ClassHint.ResolveKind.PROPERTY)) {
            return;
        }
        PsiElement grCall = place.getParent();
        if (grCall instanceof GrMethodCall && (grClosure = grCall.getParent()) instanceof GrClosableBlock && (contentField = grClosure.getParent()) instanceof GrField && "content".equals((f = (GrField)contentField).getName()) && f.hasModifierProperty("static") && f.getContainingClass() == aClass) {
            Map<String, PsiField> elements = GebUtil.getContentElements(aClass);
            for (PsiField field : elements.values()) {
                if (field.getNavigationElement() != place) continue;
                return;
            }
        }
        GebPageMemberContributor.processPageFields(processor, aClass, state);
    }

    public static boolean processPageFields(PsiScopeProcessor processor, @NotNull PsiClass pageClass, ResolveState state) {
        if (pageClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageClass", "org/jetbrains/plugins/groovy/geb/GebPageMemberContributor", "processPageFields"));
        }
        Map<String, PsiClass> supers = ClassUtil.getSuperClassesWithCache(pageClass);
        String nameHint = ResolveUtil.getNameHint(processor);
        for (PsiClass psiClass : supers.values()) {
            Map<String, PsiField> contentFields = GebUtil.getContentElements(psiClass);
            if (nameHint == null) {
                for (Map.Entry<String, PsiField> entry : contentFields.entrySet()) {
                    if (processor.execute((PsiElement)entry.getValue(), state)) continue;
                    return false;
                }
                continue;
            }
            PsiField field = contentFields.get(nameHint);
            if (field == null) continue;
            return processor.execute((PsiElement)field, state);
        }
        return true;
    }
}

