/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractConfigUtils;
import org.jetbrains.plugins.groovy.gant.GantSettings;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GantUtils {
    @NonNls
    public static final String GANT_JAR_FILE_PATTERN = "gant((_groovy)?|-)\\d.*\\.jar";

    private GantUtils() {
    }

    public static GrArgumentLabel[] getScriptTargets(GroovyFile file) {
        ArrayList<GrArgumentLabel> labels = new ArrayList<GrArgumentLabel>();
        for (PsiElement child : file.getChildren()) {
            GrArgumentLabel label;
            GrMethodCallExpression call;
            GrNamedArgument[] arguments;
            if (!(child instanceof GrMethodCallExpression) || (arguments = (call = (GrMethodCallExpression)child).getNamedArguments()).length != 1 || (label = arguments[0].getLabel()) == null || !GantUtils.isPlainIdentifier(label)) continue;
            labels.add(label);
        }
        return labels.toArray(new GrArgumentLabel[labels.size()]);
    }

    public static boolean isPlainIdentifier(GrArgumentLabel label) {
        PsiElement elem = label.getNameElement();
        ASTNode node = elem.getNode();
        if (node == null) {
            return false;
        }
        return node.getElementType() == GroovyTokenTypes.mIDENT;
    }

    public static String getGantVersion(String path) {
        String jarVersion = AbstractConfigUtils.getSDKJarVersion(path + "/lib", "gant-\\d.*\\.jar", "META-INF/MANIFEST.MF");
        return jarVersion != null ? jarVersion : "undefined";
    }

    public static boolean isGantSdkHome(VirtualFile file) {
        if (file != null && file.isDirectory()) {
            String path = file.getPath();
            if (GroovyUtils.getFilesInDirectoryByPattern(path + "/lib", GANT_JAR_FILE_PATTERN).length > 0) {
                return true;
            }
            if (GroovyUtils.getFilesInDirectoryByPattern(path + "/embeddable", GANT_JAR_FILE_PATTERN).length > 0) {
                return true;
            }
            if (file.findFileByRelativePath("bin/gant") != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSDKLibrary(Library library) {
        if (library == null) {
            return false;
        }
        return GantUtils.isGantLibrary(library.getFiles(OrderRootType.CLASSES));
    }

    public static boolean isGantLibrary(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!GantUtils.isGantJarFile(file.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGantJarFile(String name) {
        return name.matches(GANT_JAR_FILE_PATTERN);
    }

    public static String getSDKVersion(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/groovy/gant/GantUtils", "getSDKVersion"));
        }
        return GantUtils.getGantVersion(GantUtils.getGantLibraryHome(library));
    }

    public static String getGantLibraryHome(Library library) {
        return GantUtils.getGantLibraryHome(library.getFiles(OrderRootType.CLASSES));
    }

    public static String getGantLibraryHome(VirtualFile[] files) {
        for (VirtualFile file : files) {
            VirtualFile gantHome;
            VirtualFile parent;
            if (!GantUtils.isGantJarFile(file.getName()) || (parent = LibrariesUtil.getLocalFile(file).getParent()) == null || (gantHome = parent.getParent()) == null) continue;
            return PathUtil.getLocalPath((VirtualFile)gantHome);
        }
        return "";
    }

    @NotNull
    public static String getSDKInstallPath(@Nullable Module module, @NotNull Project project) {
        String fromClasspath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/gant/GantUtils", "getSDKInstallPath"));
        }
        if (module != null && (fromClasspath = GantUtils.getSdkHomeFromClasspath(module)) != null) {
            String string = fromClasspath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/GantUtils", "getSDKInstallPath"));
            }
            return string;
        }
        VirtualFile sdkHome = GantSettings.getInstance(project).getSdkHome();
        String string = sdkHome != null ? sdkHome.getPath() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/gant/GantUtils", "getSDKInstallPath"));
        }
        return string;
    }

    @Nullable
    public static String getSdkHomeFromClasspath(@NotNull Module module) {
        String home;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/gant/GantUtils", "getSdkHomeFromClasspath"));
        }
        Library[] libraries = LibrariesUtil.getLibrariesByCondition(module, new Condition<Library>(){

            public boolean value(Library library1) {
                return GantUtils.isSDKLibrary(library1);
            }
        });
        if (libraries.length != 0 && StringUtil.isNotEmpty((String)(home = GantUtils.getGantLibraryHome(libraries[0])))) {
            return home;
        }
        return null;
    }

    public static boolean isSDKConfiguredToRun(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/gant/GantUtils", "isSDKConfiguredToRun"));
        }
        return !GantUtils.getSDKInstallPath(module, module.getProject()).isEmpty();
    }
}

