/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.NestingDepthVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyOverlyNestedMethodInspectionBase
extends GroovyMethodMetricInspection {
    @NotNull
    public String getDisplayName() {
        if ("Overly nested method" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyNestedMethodInspectionBase", "getDisplayName"));
        }
        return "Overly nested method";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Method Metrics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyNestedMethodInspectionBase", "getGroupDisplayName"));
        }
        return "Method Metrics";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Maximum nesting depth:";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Method '#ref' is overly nested ( nesting depth =" + args[0] + '>' + args[1] + ')';
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyOverlyNestedMethodInspectionBase", "buildVisitor"));
        }
        return visitor;
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            int limit = GroovyOverlyNestedMethodInspectionBase.this.getLimit();
            NestingDepthVisitor visitor = new NestingDepthVisitor();
            GrOpenBlock body = grMethod.getBlock();
            if (body == null) {
                return;
            }
            body.accept(visitor);
            int nestingDepth = visitor.getMaximumDepth();
            if (nestingDepth <= limit) {
                return;
            }
            this.registerMethodError(grMethod, nestingDepth, limit);
        }
    }
}

