/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ConvertToJavaHandler;

public class ConvertToJavaAction
extends BaseRefactoringAction {
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/actions/ConvertToJavaAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/actions/ConvertToJavaAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/actions/ConvertToJavaAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/actions/ConvertToJavaAction", "isAvailableOnElementInEditorAndFile"));
        }
        return this.isEnabledOnElements(new PsiElement[]{element});
    }

    protected boolean isEnabledOnDataContext(DataContext dataContext) {
        return super.isEnabledOnDataContext(dataContext);
    }

    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return GroovyLanguage.INSTANCE == language;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/groovy/actions/ConvertToJavaAction", "isEnabledOnElements"));
        }
        for (PsiElement element : elements) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof GroovyFile) continue;
            return false;
        }
        return true;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/plugins/groovy/actions/ConvertToJavaAction", "getHandler"));
        }
        return new ConvertToJavaHandler();
    }
}

