/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.api.specs.Spec;
import org.gradle.execution.TaskSelector;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.LinePrefixingStyledTextOutput;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDetailPrinter {
    private final String taskPath;
    private final TaskSelector.TaskSelection selection;
    private static final String INDENT = "     ";
    private final OptionReader optionReader;

    public TaskDetailPrinter(String taskPath, TaskSelector.TaskSelection selection, OptionReader optionReader) {
        this.taskPath = taskPath;
        this.selection = selection;
        this.optionReader = optionReader;
    }

    public void print(StyledTextOutput output) {
        List tasks = CollectionUtils.sort((Iterable)this.selection.getTasks());
        output.text((Object)"Detailed task information for ").withStyle(StyledTextOutput.Style.UserInput).println((Object)this.taskPath);
        ListMultimap<Class, Task> classListMap = this.groupTasksByType(tasks);
        Set classes = classListMap.keySet();
        boolean multipleClasses = classes.size() > 1;
        List sortedClasses = CollectionUtils.sort((Iterable)classes, (Comparator)new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        for (Class clazz : sortedClasses) {
            output.println();
            List tasksByType = classListMap.get((Object)clazz);
            LinePrefixingStyledTextOutput pathOutput = this.createIndentedOutput(output, INDENT);
            pathOutput.println((Object)(tasksByType.size() > 1 ? "Paths" : "Path"));
            for (Task task : tasksByType) {
                pathOutput.withStyle(StyledTextOutput.Style.UserInput).println((Object)task.getPath());
            }
            output.println();
            LinePrefixingStyledTextOutput typeOutput = this.createIndentedOutput(output, INDENT);
            typeOutput.println((Object)"Type");
            typeOutput.withStyle(StyledTextOutput.Style.UserInput).text((Object)clazz.getSimpleName());
            typeOutput.println((Object)String.format(" (%s)", clazz.getName()));
            this.printlnCommandlineOptions(output, tasksByType);
            output.println();
            this.printTaskDescription(output, tasksByType);
            output.println();
            this.printTaskGroup(output, tasksByType);
            if (!multipleClasses) continue;
            output.println();
            output.println((Object)"----------------------");
        }
    }

    private ListMultimap<Class, Task> groupTasksByType(List<Task> tasks) {
        TreeSet<Class> taskTypes = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class o1, Class o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        taskTypes.addAll(CollectionUtils.collect(tasks, (Transformer)new Transformer<Class, Task>(){

            public Class transform(Task original) {
                return TaskDetailPrinter.this.getDeclaredTaskType(original);
            }
        }));
        ArrayListMultimap tasksGroupedByType = ArrayListMultimap.create();
        for (final Class taskType : taskTypes) {
            tasksGroupedByType.putAll((Object)taskType, (Iterable)CollectionUtils.filter(tasks, (Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task element) {
                    return TaskDetailPrinter.this.getDeclaredTaskType(element).equals(taskType);
                }
            }));
        }
        return tasksGroupedByType;
    }

    private Class getDeclaredTaskType(Task original) {
        Class clazz = new DslObject((Object)original).getDeclaredType();
        if (clazz.equals(DefaultTask.class)) {
            return Task.class;
        }
        return clazz;
    }

    private void printTaskDescription(StyledTextOutput output, List<Task> tasks) {
        this.printTaskAttribute(output, "Description", tasks, new Transformer<String, Task>(){

            public String transform(Task task) {
                return task.getDescription();
            }
        });
    }

    private void printTaskGroup(StyledTextOutput output, List<Task> tasks) {
        this.printTaskAttribute(output, "Group", tasks, new Transformer<String, Task>(){

            public String transform(Task task) {
                return task.getGroup();
            }
        });
    }

    private void printTaskAttribute(StyledTextOutput output, String attributeHeader, List<Task> tasks, Transformer<String, Task> transformer) {
        int count = ((HashSet)CollectionUtils.collect(tasks, new HashSet(), transformer)).size();
        LinePrefixingStyledTextOutput attributeOutput = this.createIndentedOutput(output, INDENT);
        if (count == 1) {
            attributeOutput.println((Object)attributeHeader);
            Task task = tasks.iterator().next();
            String value = (String)transformer.transform((Object)task);
            attributeOutput.println((Object)(value == null ? "-" : value));
        } else {
            attributeOutput.println((Object)(attributeHeader + "s"));
            for (Task task : tasks) {
                attributeOutput.withStyle(StyledTextOutput.Style.UserInput).text((Object)String.format("(%s) ", task.getPath()));
                String value = (String)transformer.transform((Object)task);
                attributeOutput.println((Object)(value == null ? "-" : value));
            }
        }
    }

    private void printlnCommandlineOptions(StyledTextOutput output, List<Task> tasks) {
        ArrayList<OptionDescriptor> allOptions = new ArrayList<OptionDescriptor>();
        for (Task task : tasks) {
            allOptions.addAll(this.optionReader.getOptions((Object)task));
        }
        if (!allOptions.isEmpty()) {
            output.println();
            output.text((Object)"Options").println();
        }
        ListMultimap<String, OptionDescriptor> optionsByName = this.groupDescriptorsByName(allOptions);
        Iterator optionNames = CollectionUtils.sort(optionsByName.asMap().keySet()).iterator();
        while (optionNames.hasNext()) {
            String currentOption = (String)optionNames.next();
            List descriptorsForCurrentName = optionsByName.get((Object)currentOption);
            String optionString = String.format("--%s", currentOption);
            output.text((Object)INDENT).withStyle(StyledTextOutput.Style.UserInput).text((Object)optionString);
            List availableValuesByDescriptor = CollectionUtils.collect((List)descriptorsForCurrentName, (Transformer)new Transformer<List<String>, OptionDescriptor>(){

                public List<String> transform(OptionDescriptor original) {
                    return original.getAvailableValues();
                }
            });
            List commonAvailableValues = CollectionUtils.intersection((Collection)availableValuesByDescriptor);
            TreeSet availableValues = new TreeSet(commonAvailableValues);
            output.text((Object)INDENT).text((Object)((OptionDescriptor)descriptorsForCurrentName.iterator().next()).getDescription());
            if (!availableValues.isEmpty()) {
                int optionDescriptionOffset = 2 * INDENT.length() + optionString.length();
                LinePrefixingStyledTextOutput prefixedOutput = this.createIndentedOutput(output, optionDescriptionOffset);
                prefixedOutput.println();
                prefixedOutput.println((Object)"Available values are:");
                for (String value : availableValues) {
                    prefixedOutput.text((Object)INDENT);
                    prefixedOutput.withStyle(StyledTextOutput.Style.UserInput).println((Object)value);
                }
            } else {
                output.println();
            }
            if (!optionNames.hasNext()) continue;
            output.println();
        }
    }

    private ListMultimap<String, OptionDescriptor> groupDescriptorsByName(List<OptionDescriptor> allOptions) {
        ArrayListMultimap optionsGroupedByName = ArrayListMultimap.create();
        for (OptionDescriptor option : allOptions) {
            optionsGroupedByName.put((Object)option.getName(), (Object)option);
        }
        return optionsGroupedByName;
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, int offset) {
        return this.createIndentedOutput(output, StringUtils.leftPad((String)"", (int)offset, (char)' '));
    }

    private LinePrefixingStyledTextOutput createIndentedOutput(StyledTextOutput output, String prefix) {
        return new LinePrefixingStyledTextOutput(output, (CharSequence)prefix, false);
    }
}

