/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.model.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.TreeMap;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.logging.StyledTextOutput;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.gradle.reporting.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelNodeRenderer
extends ReportRenderer<ModelNode, TextReportBuilder> {
    private static final int LABEL_LENGTH = 7;
    private final boolean showHidden;

    public ModelNodeRenderer(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void render(ModelNode model, TextReportBuilder output) {
        if (model.isHidden() && !this.showHidden) {
            return;
        }
        StyledTextOutput styledTextoutput = output.getOutput();
        if (!model.getPath().equals((Object)ModelPath.ROOT)) {
            this.printNodeName(model, styledTextoutput);
            this.maybePrintType(model, styledTextoutput);
            this.maybePrintValue(model, styledTextoutput);
            this.printCreator(model, styledTextoutput);
            this.maybePrintRules(model, styledTextoutput);
        }
        TreeMap<String, ModelNode> links = new TreeMap<String, ModelNode>();
        for (ModelNode node : model.getLinks(ModelType.untyped())) {
            links.put(node.getPath().getName(), node);
        }
        output.collection(links.values(), this);
    }

    public void printNodeName(ModelNode model, StyledTextOutput styledTextoutput) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Identifier).format("+ %s", new Object[]{model.getPath().getName()});
        styledTextoutput.println();
    }

    public void printCreator(ModelNode model, StyledTextOutput styledTextoutput) {
        ModelRuleDescriptor descriptor = model.getDescriptor();
        StringBuffer buffer = new StringBuffer();
        descriptor.describeTo((Appendable)buffer);
        this.printNodeAttribute(styledTextoutput, "Creator:", buffer.toString());
    }

    public void maybePrintType(ModelNode model, StyledTextOutput styledTextoutput) {
        Optional typeDescription = model.getTypeDescription();
        if (typeDescription.isPresent()) {
            this.printNodeAttribute(styledTextoutput, "Type:", (String)typeDescription.get());
        }
    }

    public void maybePrintValue(ModelNode model, StyledTextOutput styledTextoutput) {
        Optional value;
        if (model.getLinkCount() == 0 && (value = model.getValueDescription()).isPresent()) {
            this.printNodeAttribute(styledTextoutput, "Value:", (String)value.get());
        }
    }

    private void maybePrintRules(ModelNode model, StyledTextOutput styledTextoutput) {
        Iterable<ModelRuleDescriptor> executedRules = ModelNodeRenderer.uniqueExecutedRulesExcludingCreator(model);
        if (!Iterables.isEmpty(executedRules)) {
            this.printNestedAttributeTitle(styledTextoutput, "Rules:");
            for (ModelRuleDescriptor ruleDescriptor : executedRules) {
                this.printNestedAttribute(styledTextoutput, "\u2937 " + ruleDescriptor.toString());
            }
        }
    }

    private void printNestedAttribute(StyledTextOutput styledTextoutput, String value) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Normal).format("         %s", new Object[]{value});
        styledTextoutput.println();
    }

    private void printNestedAttributeTitle(StyledTextOutput styledTextoutput, String title) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Identifier).format("      | %s", new Object[]{title});
        styledTextoutput.println();
    }

    public void printNodeAttribute(StyledTextOutput styledTextoutput, String label, String value) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Identifier).format("      | %s", new Object[]{this.attributeLabel(label)});
        styledTextoutput.withStyle(StyledTextOutput.Style.Description).format(" \t%s", new Object[]{value});
        styledTextoutput.println();
    }

    private String attributeLabel(String label) {
        return Strings.padEnd((String)label, (int)7, (char)' ');
    }

    static Iterable<ModelRuleDescriptor> uniqueExecutedRulesExcludingCreator(final ModelNode model) {
        Iterable filtered = Iterables.filter((Iterable)model.getExecutedRules(), (Predicate)new Predicate<ModelRuleDescriptor>(){

            public boolean apply(ModelRuleDescriptor input) {
                return !input.equals(model.getDescriptor());
            }
        });
        return ImmutableSet.copyOf((Iterable)filtered);
    }
}

