/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextRangeUtil {
    private static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange range1, TextRange range2) {
            int startOffsetDiff = range1.getStartOffset() - range2.getStartOffset();
            return startOffsetDiff != 0 ? startOffsetDiff : range1.getEndOffset() - range2.getEndOffset();
        }
    };

    private TextRangeUtil() {
    }

    public static Iterable<TextRange> excludeRanges(@NotNull TextRange original, @NotNull List<TextRange> excludedRanges) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/util/text/TextRangeUtil", "excludeRanges"));
        }
        if (excludedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedRanges", "com/intellij/util/text/TextRangeUtil", "excludeRanges"));
        }
        if (!excludedRanges.isEmpty()) {
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            if (excludedRanges.size() > 1) {
                Collections.sort(excludedRanges, RANGE_COMPARATOR);
            }
            int enabledRangeStart = original.getStartOffset();
            for (TextRange excludedRange : excludedRanges) {
                if (excludedRange.getEndOffset() < enabledRangeStart) continue;
                int excludedRangeStart = excludedRange.getStartOffset();
                if (excludedRangeStart > original.getEndOffset()) break;
                if (excludedRangeStart > enabledRangeStart) {
                    enabledRanges.add(new TextRange(enabledRangeStart, excludedRangeStart));
                }
                enabledRangeStart = excludedRange.getEndOffset();
            }
            if (enabledRangeStart < original.getEndOffset()) {
                enabledRanges.add(new TextRange(enabledRangeStart, original.getEndOffset()));
            }
            return enabledRanges;
        }
        return Arrays.asList(original);
    }
}

