/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.messaging.remote.Address;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.EncodedStream;
import org.gradle.process.internal.child.ImplementationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.IsolatedGradleWorkerMain;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInIsolatedClassLoaderWorkerFactory
implements WorkerFactory {
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final Collection<URL> implementationClassPath;
    private final Address serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInIsolatedClassLoaderWorkerFactory(Object workerId, String displayName, WorkerProcessBuilder processBuilder, Collection<URL> implementationClassPath, Address serverAddress, ClassPathRegistry classPathRegistry) {
        this.workerId = workerId;
        this.displayName = displayName;
        this.processBuilder = processBuilder;
        this.implementationClassPath = implementationClassPath;
        this.serverAddress = serverAddress;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public void prepareJavaCommand(JavaExecSpec execSpec) {
        execSpec.setMain(IsolatedGradleWorkerMain.class.getName());
        execSpec.classpath(this.classPathRegistry.getClassPath("WORKER_PROCESS").getAsFiles());
        List applicationClassPath = new DefaultClassPath(this.processBuilder.getApplicationClasspath()).getAsURIs();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            DataOutputStream outstr = new DataOutputStream(new EncodedStream.EncodedOutput(bytes));
            outstr.writeInt(applicationClassPath.size());
            for (URI entry : applicationClassPath) {
                outstr.writeUTF(entry.toString());
            }
            GUtil.serialize((Object)this.create(), (OutputStream)outstr);
            outstr.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        execSpec.setStandardInput(new ByteArrayInputStream(bytes.toByteArray()));
    }

    private ImplementationClassLoaderWorker create() {
        ActionExecutionWorker injectedWorker = new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress, this.processBuilder.getGradleUserHomeDir());
        return new ImplementationClassLoaderWorker(this.processBuilder.getLogLevel(), this.processBuilder.getSharedPackages(), this.implementationClassPath, GUtil.serialize((Object)injectedWorker));
    }
}

