/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DelegatingDomainObjectSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPublishArtifactSet
extends DelegatingDomainObjectSet<PublishArtifact>
implements PublishArtifactSet {
    private final TaskDependencyInternal builtBy = new ArtifactsTaskDependency();
    private final ArtifactsFileCollection files = new ArtifactsFileCollection();
    private final String displayName;

    public DefaultPublishArtifactSet(String displayName, DomainObjectSet<PublishArtifact> backingSet) {
        super(backingSet);
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public FileCollection getFiles() {
        return this.files;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return this.builtBy;
    }

    private class ArtifactsTaskDependency
    extends AbstractTaskDependency {
        private ArtifactsTaskDependency() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            for (PublishArtifact publishArtifact : DefaultPublishArtifactSet.this) {
                context.add(publishArtifact);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtifactsFileCollection
    extends AbstractFileCollection {
        private ArtifactsFileCollection() {
        }

        @Override
        public String getDisplayName() {
            return DefaultPublishArtifactSet.this.displayName;
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return DefaultPublishArtifactSet.this.builtBy;
        }

        @Override
        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (PublishArtifact artifact : DefaultPublishArtifactSet.this) {
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

