/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.descriptors.IdDisplay;
import java.io.File;
import java.util.Collections;
import java.util.Map;

public final class AvdInfo
implements Comparable<AvdInfo> {
    private final String mName;
    private final File mIniFile;
    private final String mFolderPath;
    private final String mTargetHash;
    private final IAndroidTarget mTarget;
    private final String mAbiType;
    private final Map<String, String> mProperties;
    private final AvdStatus mStatus;
    private final IdDisplay mTag;

    public AvdInfo(String name, File iniFile, String folderPath, String targetHash, IAndroidTarget target, IdDisplay tag, String abiType, Map<String, String> properties) {
        this(name, iniFile, folderPath, targetHash, target, tag, abiType, properties, AvdStatus.OK);
    }

    public AvdInfo(String name, File iniFile, String folderPath, String targetHash, IAndroidTarget target, IdDisplay tag, String abiType, Map<String, String> properties, AvdStatus status) {
        this.mName = name;
        this.mIniFile = iniFile;
        this.mFolderPath = folderPath;
        this.mTargetHash = targetHash;
        this.mTarget = target;
        this.mTag = tag;
        this.mAbiType = abiType;
        this.mProperties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
        this.mStatus = status;
    }

    public String getName() {
        return this.mName;
    }

    public String getDataFolderPath() {
        return this.mFolderPath;
    }

    public IdDisplay getTag() {
        return this.mTag;
    }

    public String getAbiType() {
        return this.mAbiType;
    }

    public String getCpuArch() {
        String cpuArch = this.mProperties.get("hw.cpu.arch");
        if (cpuArch != null) {
            return cpuArch;
        }
        return "arm";
    }

    public String getDeviceManufacturer() {
        String deviceManufacturer = this.mProperties.get("hw.device.manufacturer");
        if (deviceManufacturer != null && !deviceManufacturer.isEmpty()) {
            return deviceManufacturer;
        }
        return "";
    }

    public String getDeviceName() {
        String deviceName = this.mProperties.get("hw.device.name");
        if (deviceName != null && !deviceName.isEmpty()) {
            return deviceName;
        }
        return "";
    }

    public static String getPrettyAbiType(AvdInfo avdInfo) {
        return AvdInfo.getPrettyAbiType(avdInfo.getTag(), avdInfo.getAbiType());
    }

    public static String getPrettyAbiType(ISystemImage sysImg) {
        return AvdInfo.getPrettyAbiType(sysImg.getTag(), sysImg.getAbiType());
    }

    public static String getPrettyAbiType(IdDisplay tag, String rawAbi) {
        String s = "";
        if (!SystemImage.DEFAULT_TAG.equals(tag)) {
            s = tag.getDisplay() + ' ';
        }
        Abi abi = Abi.getEnum(rawAbi);
        s = s + (abi == null ? rawAbi : abi.getDisplayName()) + " (" + rawAbi + ')';
        return s;
    }

    public String getTargetHash() {
        return this.mTargetHash;
    }

    public IAndroidTarget getTarget() {
        return this.mTarget;
    }

    public AvdStatus getStatus() {
        return this.mStatus;
    }

    public static File getDefaultAvdFolder(AvdManager manager, String avdName, boolean unique) throws AndroidLocation.AndroidLocationException {
        String base = manager.getBaseAvdFolder();
        File result = new File(base, avdName + ".avd");
        if (unique) {
            int suffix = 0;
            while (result.exists()) {
                result = new File(base, String.format("%s_%d%s", avdName, ++suffix, ".avd"));
            }
        }
        return result;
    }

    @Deprecated
    public static File getDefaultAvdFolder(AvdManager manager, String avdName) throws AndroidLocation.AndroidLocationException {
        return AvdInfo.getDefaultAvdFolder(manager, avdName, false);
    }

    public static File getDefaultIniFile(AvdManager manager, String avdName) throws AndroidLocation.AndroidLocationException {
        String avdRoot = manager.getBaseAvdFolder();
        return new File(avdRoot, avdName + ".ini");
    }

    public File getIniFile() {
        return this.mIniFile;
    }

    public static File getConfigFile(String path) {
        return new File(path, "config.ini");
    }

    public File getConfigFile() {
        return AvdInfo.getConfigFile(this.mFolderPath);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public String getErrorMessage() {
        switch (this.mStatus) {
            case ERROR_PATH: {
                return String.format("Missing AVD 'path' property in %1$s", this.getIniFile());
            }
            case ERROR_CONFIG: {
                return String.format("Missing config.ini file in %1$s", this.mFolderPath);
            }
            case ERROR_TARGET_HASH: {
                return String.format("Missing 'target' property in %1$s", this.getIniFile());
            }
            case ERROR_TARGET: {
                return String.format("Unknown target '%1$s' in %2$s", this.mTargetHash, this.getIniFile());
            }
            case ERROR_PROPERTIES: {
                return String.format("Failed to parse properties from %1$s", this.getConfigFile());
            }
            case ERROR_IMAGE_DIR: {
                return String.format("Missing system image for %1$s%2$s %3$s. Run 'android update avd -n %4$s'", SystemImage.DEFAULT_TAG.equals(this.mTag) ? "" : this.mTag.getDisplay() + " ", this.mAbiType, this.mTarget.getFullName(), this.mName);
            }
            case ERROR_DEVICE_CHANGED: {
                return String.format("%1$s %2$s configuration has changed since AVD creation", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case ERROR_DEVICE_MISSING: {
                return String.format("%1$s %2$s no longer exists as a device", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case OK: {
                assert (false);
                return null;
            }
        }
        return null;
    }

    @Override
    public int compareTo(AvdInfo o) {
        if (this.mTarget == null && o != null && o.mTarget == null) {
            return 0;
        }
        if (this.mTarget == null) {
            return 1;
        }
        if (o == null || o.mTarget == null) {
            return -1;
        }
        int targetDiff = this.mTarget.compareTo(o.mTarget);
        if (targetDiff == 0) {
            return this.mName.compareTo(o.mName);
        }
        return targetDiff;
    }

    public static enum AvdStatus {
        OK,
        ERROR_PATH,
        ERROR_CONFIG,
        ERROR_TARGET_HASH,
        ERROR_TARGET,
        ERROR_PROPERTIES,
        ERROR_IMAGE_DIR,
        ERROR_DEVICE_CHANGED,
        ERROR_DEVICE_MISSING,
        ERROR_IMAGE_MISSING;

    }
}

