/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import org.jetbrains.annotations.NotNull;

public class ResourceEntry {
    private final String myType;
    private final String myName;
    private final String myContext;

    public ResourceEntry(@NotNull String type, @NotNull String name, @NotNull String context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/util/ResourceEntry", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/util/ResourceEntry", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/util/ResourceEntry", "<init>"));
        }
        this.myType = type;
        this.myName = name;
        this.myContext = context;
    }

    @NotNull
    public String getContext() {
        String string = this.myContext;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/ResourceEntry", "getContext"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/ResourceEntry", "getName"));
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.myType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/util/ResourceEntry", "getType"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntry that = (ResourceEntry)o;
        if (!this.myContext.equals(that.myContext)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myType.equals(that.myType);
    }

    public int hashCode() {
        int result = this.myType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myContext.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + '(' + this.myType + ',' + this.myName + (this.myContext.isEmpty() ? "" : ',' + this.myContext + ')');
    }
}

