/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.build.SymbolLoader;
import com.android.sdklib.internal.build.SymbolWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidApt {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.tools.AndroidApt");
    @NonNls
    private static final String COMMAND_CRUNCH = "crunch";
    @NonNls
    private static final String COMMAND_PACKAGE = "package";
    private static final FileFilter PNG_FILES_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || FileUtilRt.extensionEquals((String)file.getName(), (String)"png");
        }
    };

    private AndroidApt() {
    }

    public static Map<AndroidCompilerMessageKind, List<String>> compile(@NotNull IAndroidTarget target, int platformToolsRevision, @NotNull String manifestFileOsPath, @NotNull String aPackage, @NotNull String outDirOsPath, @NotNull String[] resourceDirsOsPaths, @NotNull String[] extraPackages, boolean nonConstantFields, @Nullable String proguardCfgOutputFileOsPath) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (manifestFileOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFileOsPath", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (outDirOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDirOsPath", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (resourceDirsOsPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDirsOsPaths", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (extraPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraPackages", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        ArrayList<Pair<String, String>> libRTxtFilesAndPackages = new ArrayList<Pair<String, String>>();
        for (String extraPackage : extraPackages) {
            libRTxtFilesAndPackages.add(Pair.create((Object)null, (Object)extraPackage));
        }
        return AndroidApt.compile(target, platformToolsRevision, manifestFileOsPath, aPackage, outDirOsPath, resourceDirsOsPaths, libRTxtFilesAndPackages, nonConstantFields, proguardCfgOutputFileOsPath, null, false);
    }

    public static Map<AndroidCompilerMessageKind, List<String>> compile(@NotNull IAndroidTarget target, int platformToolsRevision, @NotNull String manifestFileOsPath, @NotNull String aPackage, @NotNull String outDirOsPath, @NotNull String[] resourceDirsOsPaths, @NotNull List<Pair<String, String>> libRTxtFilesAndPackages, boolean nonConstantFields, @Nullable String proguardCfgOutputFileOsPath, @Nullable String rTxtOutDirOsPath, boolean optimizeRFile) throws IOException {
        File rJavaFile;
        String packageFolderOsPath;
        File manifestJavaFile;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (manifestFileOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFileOsPath", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (outDirOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDirOsPath", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (resourceDirsOsPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDirsOsPaths", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        if (libRTxtFilesAndPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libRTxtFilesAndPackages", "org/jetbrains/android/compiler/tools/AndroidApt", "compile"));
        }
        HashMap messages = new HashMap();
        messages.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        messages.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        File outOsDir = new File(outDirOsPath);
        if (!outOsDir.exists() && !outOsDir.mkdirs()) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to create directory " + outDirOsPath);
        }
        if ((manifestJavaFile = new File((packageFolderOsPath = FileUtil.toSystemDependentName((String)(outDirOsPath + '/' + aPackage.replace('.', '/')))) + File.separatorChar + "Manifest.java")).exists() && !FileUtil.delete((File)manifestJavaFile)) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to delete " + manifestJavaFile.getPath());
        }
        if ((rJavaFile = new File(packageFolderOsPath + File.separatorChar + "R.java")).exists() && !FileUtil.delete((File)rJavaFile)) {
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to delete " + rJavaFile.getPath());
        }
        File[] extraRJavaFiles = new File[libRTxtFilesAndPackages.size()];
        int n = libRTxtFilesAndPackages.size();
        for (int i = 0; i < n; ++i) {
            String libPackage = (String)libRTxtFilesAndPackages.get(i).getSecond();
            String libPackageFolderOsPath = FileUtil.toSystemDependentName((String)(outDirOsPath + '/' + libPackage.replace('.', '/')));
            extraRJavaFiles[i] = new File(libPackageFolderOsPath + File.separatorChar + "R.java");
        }
        for (File extraRJavaFile : extraRJavaFiles) {
            if (!extraRJavaFile.exists() || FileUtil.delete((File)extraRJavaFile)) continue;
            ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("Unable to delete " + extraRJavaFile.getPath());
        }
        if (platformToolsRevision < 0 || platformToolsRevision > 7) {
            Map<AndroidCompilerMessageKind, List<String>> map = AndroidApt.doCompile(target, manifestFileOsPath, outDirOsPath, resourceDirsOsPaths, libRTxtFilesAndPackages, null, nonConstantFields, proguardCfgOutputFileOsPath, rTxtOutDirOsPath, optimizeRFile);
            if (map.get((Object)AndroidCompilerMessageKind.ERROR).isEmpty()) {
                AndroidApt.makeFieldsNotFinal(extraRJavaFiles);
            }
            AndroidExecutionUtil.addMessages(messages, map);
            return messages;
        }
        ((List)messages.get((Object)AndroidCompilerMessageKind.ERROR)).add("'Platform Tools' package is out of date. Please update it through Android SDK manager");
        return messages;
    }

    private static void makeFieldsNotFinal(@NotNull File[] libRJavaFiles) throws IOException {
        if (libRJavaFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libRJavaFiles", "org/jetbrains/android/compiler/tools/AndroidApt", "makeFieldsNotFinal"));
        }
        for (File file : libRJavaFiles) {
            if (!file.isFile()) continue;
            String fileContent = AndroidCommonUtils.readFile(file);
            FileUtil.writeToFile((File)file, (String)fileContent.replace("public static final int ", "public static int "));
        }
    }

    private static Map<AndroidCompilerMessageKind, List<String>> doCompile(@NotNull IAndroidTarget target, @NotNull String manifestFileOsPath, @NotNull String outDirOsPath, @NotNull String[] resourceDirsOsPaths, @NotNull List<Pair<String, String>> libRTxtFilesAndPackages, @Nullable String customPackage, boolean nonConstantIds, @Nullable String proguardCfgOutputFileOsPath, @Nullable String rTxtOutDirOsPath, boolean optimizeRFile) throws IOException {
        File rFile;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/tools/AndroidApt", "doCompile"));
        }
        if (manifestFileOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFileOsPath", "org/jetbrains/android/compiler/tools/AndroidApt", "doCompile"));
        }
        if (outDirOsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDirOsPath", "org/jetbrains/android/compiler/tools/AndroidApt", "doCompile"));
        }
        if (resourceDirsOsPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceDirsOsPaths", "org/jetbrains/android/compiler/tools/AndroidApt", "doCompile"));
        }
        if (libRTxtFilesAndPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libRTxtFilesAndPackages", "org/jetbrains/android/compiler/tools/AndroidApt", "doCompile"));
        }
        ArrayList<String> args = new ArrayList<String>();
        BuildToolInfo buildToolInfo = target.getBuildToolInfo();
        if (buildToolInfo == null) {
            return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
        }
        args.add(buildToolInfo.getPath(BuildToolInfo.PathId.AAPT));
        args.add(COMMAND_PACKAGE);
        args.add("-m");
        if (nonConstantIds) {
            args.add("--non-constant-id");
        }
        if (resourceDirsOsPaths.length > 1) {
            args.add("--auto-add-overlay");
        }
        HashSet extraPackages = new HashSet();
        for (Pair<String, String> pair : libRTxtFilesAndPackages) {
            extraPackages.add(pair.getSecond());
        }
        if (extraPackages.size() > 0) {
            args.add("--extra-packages");
            args.add(AndroidApt.toPackagesString(ArrayUtil.toStringArray((Collection)extraPackages)));
        }
        if (customPackage != null) {
            args.add("--custom-package");
            args.add(customPackage);
        }
        if (rTxtOutDirOsPath != null) {
            args.add("--output-text-symbols");
            args.add(rTxtOutDirOsPath);
        }
        args.add("-J");
        args.add(outDirOsPath);
        args.add("-M");
        args.add(manifestFileOsPath);
        for (String libResFolderOsPath : resourceDirsOsPaths) {
            args.add("-S");
            args.add(libResFolderOsPath);
        }
        args.add("-I");
        args.add(target.getPath(1));
        if (proguardCfgOutputFileOsPath != null) {
            args.add("-G");
            args.add(proguardCfgOutputFileOsPath);
        }
        Map<AndroidCompilerMessageKind, List<String>> messages = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(args));
        LOG.info(AndroidCommonUtils.command2string(args));
        if (messages.get((Object)AndroidCompilerMessageKind.ERROR).size() > 0) {
            return messages;
        }
        if (optimizeRFile && !libRTxtFilesAndPackages.isEmpty() && rTxtOutDirOsPath != null && (rFile = new File(rTxtOutDirOsPath, "R.txt")).isFile()) {
            SymbolLoader fullSymbolValues = new SymbolLoader(rFile);
            fullSymbolValues.load();
            MultiMap libMap = new MultiMap();
            for (Pair<String, String> pair : libRTxtFilesAndPackages) {
                File rTextFile = new File((String)pair.getFirst());
                String libPackage = (String)pair.getSecond();
                if (!rTextFile.isFile()) continue;
                SymbolLoader libSymbols = new SymbolLoader(rTextFile);
                libSymbols.load();
                libMap.putValue((Object)libPackage, (Object)libSymbols);
            }
            for (Map.Entry entry : libMap.entrySet()) {
                String libPackage = (String)entry.getKey();
                Collection symbols = (Collection)entry.getValue();
                SymbolWriter writer = new SymbolWriter(outDirOsPath, libPackage, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
        return messages;
    }

    @NotNull
    private static String toPackagesString(@NotNull String[] packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "org/jetbrains/android/compiler/tools/AndroidApt", "toPackagesString"));
        }
        StringBuilder builder = new StringBuilder();
        int n = packages.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append(':');
            }
            builder.append(packages[i]);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/tools/AndroidApt", "toPackagesString"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<AndroidCompilerMessageKind, List<String>> crunch(@NotNull IAndroidTarget target, @NotNull List<String> resPaths, @NotNull String outputPath) throws IOException {
        Map<AndroidCompilerMessageKind, List<String>> map;
        block11: {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/tools/AndroidApt", COMMAND_CRUNCH));
            }
            if (resPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resPaths", "org/jetbrains/android/compiler/tools/AndroidApt", COMMAND_CRUNCH));
            }
            if (outputPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/android/compiler/tools/AndroidApt", COMMAND_CRUNCH));
            }
            BuildToolInfo buildToolInfo = target.getBuildToolInfo();
            if (buildToolInfo == null) {
                return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(buildToolInfo.getPath(BuildToolInfo.PathId.AAPT));
            args.add(COMMAND_CRUNCH);
            File tempDir = null;
            try {
                if (resPaths.size() > 0) {
                    if (resPaths.size() == 1) {
                        args.add("-S");
                        args.add(resPaths.get(0));
                    } else {
                        tempDir = FileUtil.createTempDirectory((String)"android_combined_resources", (String)"tmp");
                        for (int i = resPaths.size() - 1; i >= 0; --i) {
                            String resDirPath = resPaths.get(i);
                            File resDir = new File(resDirPath);
                            if (!resDir.exists()) continue;
                            FileUtil.copyDir((File)resDir, (File)tempDir, (FileFilter)PNG_FILES_FILTER);
                        }
                        args.add("-S");
                        args.add(tempDir.getPath());
                    }
                }
                args.add("-C");
                args.add(outputPath);
                LOG.info(AndroidCommonUtils.command2string(args));
                map = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(args));
                if (tempDir == null) break block11;
            }
            catch (Throwable throwable) {
                if (tempDir != null) {
                    FileUtil.delete(tempDir);
                }
                throw throwable;
            }
            FileUtil.delete((File)tempDir);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<AndroidCompilerMessageKind, List<String>> packageResources(@NotNull IAndroidTarget target, int platformToolsRevision, @NotNull String manifestPath, @NotNull String[] resPaths, @NotNull String[] osAssetDirPaths, @NotNull String outputPath, @Nullable String configFilter, boolean debugMode, int versionCode, @Nullable String customManifestPackage, @Nullable String additionalParameters, FileFilter assetsFilter) throws IOException {
        Map<AndroidCompilerMessageKind, List<String>> map;
        block23: {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/tools/AndroidApt", "packageResources"));
            }
            if (manifestPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestPath", "org/jetbrains/android/compiler/tools/AndroidApt", "packageResources"));
            }
            if (resPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resPaths", "org/jetbrains/android/compiler/tools/AndroidApt", "packageResources"));
            }
            if (osAssetDirPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "osAssetDirPaths", "org/jetbrains/android/compiler/tools/AndroidApt", "packageResources"));
            }
            if (outputPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPath", "org/jetbrains/android/compiler/tools/AndroidApt", "packageResources"));
            }
            for (String resDirPath : resPaths) {
                if (!FileUtil.isAncestor((String)resDirPath, (String)outputPath, (boolean)false)) continue;
                throw new IOException("Resource directory " + FileUtil.toSystemDependentName((String)resDirPath) + " contains output " + FileUtil.toSystemDependentName((String)outputPath));
            }
            for (String assetsDirPath : osAssetDirPaths) {
                if (!FileUtil.isAncestor((String)assetsDirPath, (String)outputPath, (boolean)false)) continue;
                throw new IOException("Assets directory " + FileUtil.toSystemDependentName((String)assetsDirPath) + " contains output " + FileUtil.toSystemDependentName((String)outputPath));
            }
            BuildToolInfo buildToolInfo = target.getBuildToolInfo();
            if (buildToolInfo == null) {
                return Collections.singletonMap(AndroidCompilerMessageKind.ERROR, Collections.singletonList("No Build Tools in the Android SDK."));
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(buildToolInfo.getPath(BuildToolInfo.PathId.AAPT));
            args.add(COMMAND_PACKAGE);
            for (String path : resPaths) {
                args.add("-S");
                args.add(path);
            }
            args.add("-f");
            if (platformToolsRevision < 0 || platformToolsRevision > 7) {
                args.add("--no-crunch");
            }
            if (resPaths.length > 1) {
                args.add("--auto-add-overlay");
            }
            if (debugMode) {
                args.add("--debug-mode");
            }
            if (versionCode > 0) {
                args.add("--version-code");
                args.add(Integer.toString(versionCode));
            }
            if (configFilter != null) {
                args.add("-c");
                args.add(configFilter);
            }
            args.add("-M");
            args.add(manifestPath);
            File tempDir = null;
            try {
                String[] nonEmptyAssetDirs;
                if (osAssetDirPaths.length > 0 && (nonEmptyAssetDirs = AndroidApt.getNonEmptyExistingDirs(osAssetDirPaths)).length > 0) {
                    if (nonEmptyAssetDirs.length == 1) {
                        args.add("-A");
                        args.add(nonEmptyAssetDirs[0]);
                    } else {
                        tempDir = FileUtil.createTempDirectory((String)"android_combined_assets", (String)"tmp");
                        for (int i = nonEmptyAssetDirs.length - 1; i >= 0; --i) {
                            String assetDir = nonEmptyAssetDirs[i];
                            FileUtil.copyDir((File)new File(assetDir), (File)tempDir, (FileFilter)assetsFilter);
                        }
                        args.add("-A");
                        args.add(tempDir.getPath());
                    }
                }
                args.add("-I");
                args.add(target.getPath(1));
                if (customManifestPackage != null) {
                    args.add("--rename-manifest-package");
                    args.add(customManifestPackage);
                }
                if (additionalParameters != null && additionalParameters.length() > 0) {
                    args.addAll(ParametersListUtil.parse((String)additionalParameters));
                }
                args.add("-F");
                args.add(outputPath);
                LOG.info(AndroidCommonUtils.command2string(args));
                map = AndroidExecutionUtil.doExecute(ArrayUtil.toStringArray(args));
                if (tempDir == null) break block23;
            }
            catch (Throwable throwable) {
                if (tempDir != null) {
                    FileUtil.delete(tempDir);
                }
                throw throwable;
            }
            FileUtil.delete((File)tempDir);
        }
        return map;
    }

    @NotNull
    private static String[] getNonEmptyExistingDirs(@NotNull String[] dirs) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "org/jetbrains/android/compiler/tools/AndroidApt", "getNonEmptyExistingDirs"));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String dirPath : dirs) {
            File[] children;
            File dir = new File(dirPath);
            if (!dir.isDirectory() || (children = dir.listFiles()) == null || children.length <= 0) continue;
            result.add(dirPath);
        }
        String[] stringArray = ArrayUtil.toStringArray(result);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/tools/AndroidApt", "getNonEmptyExistingDirs"));
        }
        return stringArray;
    }
}

